<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php wp_title('&laquo;', true, 'right'); ?> <?php bloginfo('name'); ?></title>
<link rel="shortcut icon" href="<?php bloginfo('stylesheet_directory'); ?>/favicon.ico" type="image/x-icon" />

<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<!-- CSS -->
<link rel="stylesheet" href="<?php bloginfo('stylesheet_directory'); ?>/css/screen.css" type="text/css" media="screen, projection"/>
<link rel="stylesheet" href="<?php bloginfo('stylesheet_directory'); ?>/css/print.css" type="text/css" media="print"/>
<!--[if lt IE 8]><link rel="stylesheet" href="<?php bloginfo('stylesheet_directory'); ?>/css/ie.css" type="text/css" media="screen, projection"/><![endif]-->
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen, projection"/>

<?php wp_enqueue_script("jquery"); ?>
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); wp_head(); ?>

<script src="<?php bloginfo("template_url"); ?>/js/js.js" type="text/javascript"></script>


</head>
<body>


<div class="container">
  <div class="span-96 last">
    <div class="span-96 last" id="top_menu">
    	<ul>
			<?php wp_list_categories("depth=1&title_li="); ?>
        </ul>
    </div><!-- end top_menu -->

    <div class="clear span-96 last">
      <div class="span-71" id="logo">
      	<h1><a href="<?php bloginfo('url'); ?>"><?php bloginfo('name'); ?></a></h1>
      	<p><?php bloginfo('description'); ?></p>
      </div><!-- end logo -->
      <div class="span-24 prepend-1 last" id="search">
		<?php get_search_form(); ?>
      </div><!-- end search -->
	        <?php
			//RSS Feed icon
				if (get_settings("wpt_show_feed") == false){
					
					if(get_settings("wpt_feed_link") == ""){
					?>
						<a href="<?php bloginfo('rss2_url'); ?>"><img style="float:right; position:relative; top:30px;" src="<?php bloginfo("template_url"); ?>/images/rss.png" alt="RSS Feed"></a>
					<?php
					}else{
					?>
						<a href="<?php echo get_settings("wpt_feed_link"); ?>"><img style="float:right; position:relative; top:30px;" src="<?php bloginfo("template_url"); ?>/images/rss.png" alt="RSS Feed"></a>
					<?php
					}
				}
			?>

	        <?php
			//Twitter icon
				if (get_settings("wpt_show_twitter") == true){
					
					if(get_settings("wpt_twitter_link") != ""){
					?>
						<a href="<?php echo get_settings("wpt_twitter_link"); ?>"><img style="float:right; position:relative; top:30px; margin-right:5px;" src="<?php bloginfo("template_url"); ?>/images/twitter.png" alt="Twitter"></a>
					<?php
					}
				}
			?>

    </div>

    <div id="content_container" class="clear span-96 last">
        <div class="clear last" id="menu">
        	<div id="menu_l"></div>
            <div id="menu_r"></div>
            <ul>
				<?php wp_list_pages("depth=1&title_li="); ?>
            </ul>
        </div><!-- end menu -->