<?php
 /**
  * Title: Service
  * Slug: wpopus-studio/service
  * Categories: wpopus-studio
  */
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"right":"var:preset|spacing|20","left":"var:preset|spacing|20","top":"100px","bottom":"100px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="padding-top:100px;padding-right:var(--wp--preset--spacing--20);padding-bottom:100px;padding-left:var(--wp--preset--spacing--20)"><!-- wp:columns {"verticalAlignment":null,"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":6,"style":{"typography":{"textTransform":"uppercase","letterSpacing":"2px"}}} -->
<h6 class="wp-block-heading" style="letter-spacing:2px;text-transform:uppercase"><?php esc_html_e( 'Our Services', 'wpopus-studio' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"800"}},"fontSize":"huge"} -->
<h2 class="wp-block-heading has-huge-font-size" style="font-style:normal;font-weight:800"><?php esc_html_e( 'Transformation of Your', 'wpopus-studio' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"800"}},"fontSize":"huge"} -->
<h2 class="wp-block-heading has-huge-font-size" style="font-style:normal;font-weight:800"><?php esc_html_e( 'Brand', 'wpopus-studio' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"className":"stroke-text","style":{"typography":{"fontStyle":"normal","fontWeight":"800"}},"fontSize":"huge"} -->
<h2 class="wp-block-heading stroke-text has-huge-font-size" style="font-style:normal;font-weight:800"><?php esc_html_e( 'Design', 'wpopus-studio' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:list {"ordered":true,"style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|body-text"}}},"spacing":{"padding":{"left":"var:preset|spacing|70","top":"var:preset|spacing|70","right":"var:preset|spacing|80"}}},"textColor":"body-text","fontSize":"moderate"} -->
<ol style="padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--80);padding-left:var(--wp--preset--spacing--70);font-style:normal;font-weight:700" class="wp-block-list has-body-text-color has-text-color has-link-color has-moderate-font-size"><!-- wp:list-item -->
<li><?php esc_html_e( 'UI/UX Design', 'wpopus-studio' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e( 'Branding Design', 'wpopus-studio' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e( 'Video Marketing', 'wpopus-studio' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e( 'Social Media Marketing', 'wpopus-studio' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e( 'App Development', 'wpopus-studio' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e( 'Web Development', 'wpopus-studio' ); ?></li>
<!-- /wp:list-item --></ol>
<!-- /wp:list --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":113,"aspectRatio":"1","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"grey-to-color-mode-effect"} -->
<figure class="wp-block-image size-full grey-to-color-mode-effect"><img src="<?php echo esc_url( get_stylesheet_directory_uri() );?>/assets/images/service.webp" alt="" class="wp-image-113" style="aspect-ratio:1;object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"70%"} -->
<div class="wp-block-column" style="flex-basis:70%"><!-- wp:group {"className":"margin-top-negative-150-large-screen margin-left-negative-150-large-screen","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70","left":"var:preset|spacing|70","right":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|40"}},"backgroundColor":"foreground","layout":{"type":"constrained"}} -->
<div class="wp-block-group margin-top-negative-150-large-screen margin-left-negative-150-large-screen has-foreground-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--70)"><!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"textColor":"background"} -->
<h4 class="wp-block-heading has-background-color has-text-color has-link-color"><?php esc_html_e( 'Creating a Strong Brand Identity Through The Design', 'wpopus-studio' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}}},"textColor":"background"} -->
<p class="has-background-color has-text-color has-link-color"><?php esc_html_e( 'We are a creative design studio specializing in branding, UI/UX, and digital experiences. We craft visually stunning, user-focused solutions that elevate brands and drive engagement.', 'wpopus-studio' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"30%"} -->
<div class="wp-block-column" style="flex-basis:30%"></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->
