<?php 
$themename = "WPElegance 2Col";
$shortname = "WPElegance 2Col";

# Template Location
define('THEME', get_bloginfo('template_url'), true);
# JS files location
define('THEME_JS', THEME . '/scripts/js', true);

wp_enqueue_script('jquery');
wp_enqueue_script('jquery-ui-core');
wp_enqueue_script('jquery-ui-tabs');
wp_enqueue_script('menu', THEME_JS .'/menu.js', array('jquery'));
wp_enqueue_script('easySlider1.5', THEME_JS .'/easySlider1.5.js', array('jquery'));
wp_enqueue_script('tabEffects', THEME_JS .'/tabEffects.js', array('jquery'));
wp_enqueue_script('slide', THEME_JS .'/slide.js', array('jquery'));

function theme_add_admin() {

 global $themename, $shortname, $options;   

if ( $_GET['page'] == basename(__FILE__) ) {
	if ( 'wpe_update' == $_REQUEST['action'] ) {
		
		update_option('wpe_featured', $_REQUEST['wpe_featured']);
		update_option('wpe_featured_count', $_REQUEST['wpe_featured_count']);
		update_option('wpe_feedburner_id', $_REQUEST['wpe_feedburner_id']);
		update_option('wpe_cat_id', $_REQUEST['wpe_cat_id']);
		update_option('wpe_med_featured', $_REQUEST['wpe_med_featured']);
		update_option('wpe_tab_sb', $_REQUEST['wpe_tab_sb']);
		update_option('wpe_middle_sb', $_REQUEST['wpe_middle_sb']);
		update_option('wpe_bottom_sb', $_REQUEST['wpe_bottom_sb']);
		update_option('wpe_footer', $_REQUEST['wpe_footer']);
		update_option('wpe_thumbnail', $_REQUEST['wpe_thumbnail']);	
		update_option('wpe_catbar', $_REQUEST['wpe_catbar']);
		update_option('wpe_banner', $_REQUEST['wpe_banner']);
		
	}
	
}
 
	add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'theme_admin');
}

function theme_admin() {

    global $themename, $shortname, $options;   
?>
 <div class="wrap">
 <h2>WP Elegance 2 Column Theme Settings</h2>
 <script type="text/javascript">
 <!--
      function toggleVisibility(id) {
         var e = document.getElementById(id);
         if(e.style.display == 'block')
            e.style.display = 'none';
         else
           e.style.display = 'block';
      }
 //-->
 </script> 
 </div>

 <?php       
        $message = null;
        $message_updated = __("WP Elegance 2 Column Theme Settings Updated.");

        // update options
        if ( $_REQUEST['saved'] ) {
            $message = $message_updated;
            
			/*$upd_options['wpe_featured'] = $_POST['wpe_featured'];
			$upd_options['wpe_featured_count'] = $_POST['wpe_featured_count'];]
			$upd_options['wpe_tab_sb'] = $_POST['wpe_tab_sb'];]
			$upd_options['wpe_middle_sb'] = $_POST['wpe_middle_sb'];
			$upd_options['wpe_bottom_sb'] = $_POST['wpe_bottom_sb'];
			$upd_options['wpe_footer'] = $_POST['wpe_footer'];
			$upd_options['wpe_thumbnail'] = $_POST['wpe_thumbnail'];
			
			update_option('wpe_options', $upd_options);
			$wpe_options = get_option('wpe_options');  */		
              
        }
        ?>
<?php if ($message) : ?>
<div id="message" class="updated fade"><p><?php echo $message; ?></p></div>
<?php endif; ?>
<div class="wrap">
 <h3><?php _e('Click on option titles to get help!') ?></h3>

 <form method="post">
 <table class="form-table"> 						
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_featured_tip');">
 <?php _e('Disable Featured Content:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_featured" id="wpe_featured" value="true" <?php if ( get_option('wpe_featured')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_featured_tip">
 <?php
 _e('Check this if you want to disable Featured Posts Section in the theme');
  ?>
 </div>
 </td>
 </tr>
 
 <tr>
<th scope="row" style="text-align:right; vertical-align:top;">
<a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility('wpe_featured_count_tip');">
<?php _e('Set number of Featured posts:')?>
</a>
</td>
<td>
<input size="1" name="wpe_featured_count" value="<?php if ( get_option('wpe_featured_count') != "") { echo stripcslashes(get_option('wpe_featured_count')); } else {echo '5';}?>"/>
<div style="max-width:500px; text-align:left; display:none" id="wpe_featured_count_tip">
<?php
_e('Here you can set the number of Featured posts to display on Home page');
 ?>
</div>
</td>
</tr>

<tr>
<th scope="row" style="text-align:right; vertical-align:top;">
<a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility('wpe_feedburner_id_tip');">
<?php _e('Set Feedburner Feed ID For Email Subscription box on sidebar:')?>
</a>
</td>
<td>
<input size="20" name="wpe_feedburner_id" value="<?php if ( get_option('wpe_feedburner_id') != "") { echo stripcslashes(get_option('wpe_feedburner_id')); } else {echo '';}?>"/>
<div style="max-width:500px; text-align:left; display:none" id="wpe_feedburner_id_tip">
<?php
_e('Here you can set the Feedburner Feed ID For Email Subscription box on sidebar');
 ?>
</div>
</td>
</tr>

<tr>
<th scope="row" style="text-align:right; vertical-align:top;">
<a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility('wpe_cat_id_tip');">
<?php _e('Set a comma seperated list of category ids to be includend in the category bar on top:')?>
</a>
</td>
<td>
<input size="25" name="wpe_cat_id" value="<?php if ( get_option('wpe_cat_id') != "") { echo stripcslashes(get_option('wpe_cat_id')); } else {echo '';}?>"/>
<div style="max-width:500px; text-align:left; display:none" id="wpe_cat_id_tip">
<?php
_e('Here you can set a comma seperated list of category ids to be includend in the category bar on top.But make sure that there are only as many category ids as may fit within the category bar.');
 ?>
</div>
</td>
</tr>

<tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_med_featured_tip');">
 <?php _e('Display medium sized image for Featured Posts (Thumbnails will be displayed in Featured Posts Section if this is not checked):')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_med_featured" id="wpe_med_featured" value="true" <?php if ( get_option('wpe_med_featured')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_med_featured_tip">
 <?php
 _e('Check this if you want to display medium image for featured posts in the theme.But make sure to set the max. width for medium images as 300 in Settings --> Media');
  ?>
 </div>
 </td>
 </tr>
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_catbar_tip');">
 <?php _e('Disable Category Bar:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_catbar" id="wpe_catbar" value="true" <?php if ( get_option('wpe_catbar')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_catbar_tip">
 <?php
 _e('Check this if you want to disable Category bar on top, in the theme');
  ?>
 </div>
 </td>
 </tr>
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_banner_tip');">
 <?php _e('Disable Header Banner:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_banner" id="wpe_banner" value="true" <?php if ( get_option('wpe_banner')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_banner_tip">
 <?php
 _e('Check this if you want to disable header banner on top, in the theme');
  ?>
 </div>
 </td>
 </tr>

<tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_tab_sb_tip');">
 <?php _e('Disable Sidebar Tab Widget:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_tab_sb" id="wpe_tab_sb" value="true" <?php if ( get_option('wpe_tab_sb')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_tab_sb_tip">
 <?php
 _e('Check this if you want to disable Tabbed Sidebar Widget in the theme');
  ?>
 </div>
 </td>
 </tr> 
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_middle_sb_tip');">
 <?php _e('Disable Middle Sidebar:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_middle_sb" id="wpe_middle_sb" value="true" <?php if ( get_option('wpe_middle_sb')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_middle_sb_tip">
 <?php
 _e('Check this if you want to disable middle Sidebar in the theme');
  ?>
 </div>
 </td>
 </tr> 
						
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_bottom_sb_tip');">
 <?php _e('Disable Bottom sidebar:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_bottom_sb" id="wpe_bottom_sb" value="true" <?php if ( get_option('wpe_bottom_sb')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_bottom_sb_tip">
 <?php
 _e('Check this if you want to disable Bottom sidebar in the theme');
  ?>
 </div>
 </td>
 </tr>
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_footer_tip');">
 <?php _e('Disable Footer:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_footer" id="wpe_footer" value="true" <?php if ( get_option('wpe_footer')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_footer_tip">
 <?php
 _e('Check this if you want to disable Footer in the theme');
  ?>
 </div>
 </td>
 </tr> 
 
 <tr>
 <th scope="row" style="text-align:right; vertical-align:top;">
 <a style="cursor:pointer;" title="<?php _e('Click for Help!')?>" onclick="toggleVisibility ('wpe_thumbnail');">
 <?php _e('Disable Thumbnail Display:')?>
 </td>
 <td>
 <input type="checkbox" name="wpe_thumbnail" id="wpe_thumbnail" value="true" <?php if ( get_option('wpe_thumbnail')) { echo "checked=\"0\""; } else {"";} ?>" />
 <div style="max-width:500px; text-align:left; display:none" id="wpe_thumbnail">
 <?php
 _e('Check this if you want to disable Thumbnail Display in the theme');
  ?>
 </div>
 </td>
 </tr>
 
</table>
 <p class="submit">
 <input type="hidden" name="action" value="wpe_update" />
 <input type="submit" name="Submit" value="<?php _e('Update Options')?> &raquo;" />
 </p>
 </form>
</div>
<?php

        } // theme admin

add_action('admin_menu', 'theme_add_admin'); 

//Register sidebars

if ( function_exists('register_sidebar') ) 
{     
register_sidebar(array('name' => 'Sidebar Top','before_widget' => '<div class="sidebar_box">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>'));
register_sidebar(array('name' => 'Sidebar Left','before_widget' => '<div class="sidebar_box">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>')); 
register_sidebar(array('name' => 'Sidebar Right','before_widget' => '<div class="sidebar_box">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>'));   
register_sidebar(array('name' => 'Sidebar Bottom','before_widget' => '<div class="sidebar_box">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>'));    
register_sidebar(array('name' => 'footerleft', 'before_widget' => '','after_widget' => '','before_title' => '<h4>','after_title' => '</h4>'));     
register_sidebar(array('name' => 'footermiddle', 'before_widget' => '','after_widget' => '','before_title' => '<h4>','after_title' => '</h4>'));     
register_sidebar(array('name' => 'footerright', 'before_widget' => '','after_widget' => '','before_title' => '<h4>','after_title' => '</h4>')); 
} 

//Improve the excerpt
function improved_trim_excerpt($text) {
	global $post;
	if ( '' == $text ) {
		$text = get_the_content('');
		$text = apply_filters('the_content', $text);
		$text = str_replace(']]>', ']]&gt;', $text);
		$text = preg_replace('@<script[^>]*?>.*?</script>@si', '', $text);
		$text = strip_tags($text, '<p><a><big><small><em><strong>');
		$excerpt_length = 55;
		$words = explode(' ', $text, $excerpt_length + 1);
		if (count($words)> $excerpt_length) {
			array_pop($words);
			array_push($words, '[...]');
			$text = implode(' ', $words);
		}
	}
	return $text;
}

remove_filter('get_the_excerpt', 'wp_trim_excerpt');
add_filter('get_the_excerpt', 'improved_trim_excerpt');

function get_thumbnail($postId) {

    // Get the post ID
    $ID = $postId;//$post->ID;
	
	// Get the thumbnail url for an image hosted elsewhere
	$sThumbUrl = htmlspecialchars(stripcslashes(get_post_meta($ID, 'wpelegance_tn', true)));
	
	if ((!isset($sThumbUrl) && empty($sThumbUrl)) || ($sThumbUrl == "")) {

	    // Get images for this ID
	    $arrImages =& get_children('post_type=attachment&post_mime_type=image&post_parent=' . $ID );

	    // If images exist for this page
	    if($arrImages) {

	        // Get array keys representing attached image numbers
	        $arrKeys = array_keys($arrImages);  
			$post_title = get_the_title($ID);

	        // Get the first image attachment
	        $iNum = $arrKeys[0];

	        // Get the thumbnail url for the attachment
	        $sThumbUrl = wp_get_attachment_thumb_url($iNum);

	        // UNCOMMENT THIS IF YOU WANT THE FULL SIZE IMAGE INSTEAD OF THE THUMBNAIL
	        //$sImageUrl = wp_get_attachment_url($iNum);
			
	    }
	}

	if ($sThumbUrl != "") {
	    // Build the <img> string
	    $sImgString = '<a href="' . get_permalink() . '">' .
	                    '<img src="' . attribute_escape($sThumbUrl) . '" class="left" alt="'.$post_title.'" title="'.$post_title.'" />' .
	                    '</a>';

	    // Print the image
	    echo $sImgString; 
	}
}

function get_medium_img($postId) {

    // Get the post ID
    $ID = $postId;//$post->ID;	
	// Get the medium sized url for an image hosted elsewhere
	$src = htmlspecialchars(stripcslashes(get_post_meta($ID, 'wpelegance_fi', true)));
	
	if ((!isset($src) && empty($src)) || ($src == "")) {

	    // Get images for this ID
	    $arrImages =& get_children('post_type=attachment&post_mime_type=image&post_parent=' . $ID );

	    // If images exist for this page
	    if($arrImages) {

	        // Get array keys representing attached image numbers
	        $arrKeys = array_keys($arrImages);  
			$post_title = get_the_title($ID);

	        // Get the first image attachment
	        $iNum = $arrKeys[0];

	        // Get the thumbnail url for the attachment
	        $image = wp_get_attachment_image_src($iNum, 'medium');		
			if ( $image ) {
				list($src, $width, $height) = $image;			
			}	
		}
	} 
	
	if ($src != "") {
		// Build the <img> string
		$sImgString = '<a href="' . get_permalink() . '">' .
                            '<img src="' . attribute_escape($src) . '" width="300" class="left" alt="'.$post_title.'" title="'.$post_title.'" />' .
                        '</a>';
		// Print the image
		echo $sImgString;
	}
	
}

function wp_footer_credits() {
 $blogname = bloginfo('name'); 
 echo "&nbsp;&nbsp;Copyright &copy; 2009 $blogname, All rights reserved.| Powered by <a href=\"http://wordpress.org/\">WordPress</a>| <a href=\"http://free-wp-themes.techblissonline.com/\" target=\"_blank\">WPElegance2Col</a> theme by <a href=\"http://techblissonline.com\" target=\"_blank\">Techblissonline.com</a>\n";
}

//comments filter for legacy template
add_filter('comments_template', 'legacy_comments');

function legacy_comments($file) {

	if(!function_exists('wp_list_comments')) : // WP 2.7-only check
		$file = TEMPLATEPATH . '/legacycomments.php';
	endif;

	return $file;
}

add_filter('get_comments_number', 'comment_count', 0);
function comment_count( $count ) {
	global $id;
	$comments_by_type = &separate_comments(get_comments('post_id=' . $id));
	return count($comments_by_type['comment']);
}

function list_pings($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment; ?>
        <li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php } 

function theme_comments ($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?> 
   
   <li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
		<div class="clearfloat">
			<?php echo get_avatar( $comment, $size = '55' ); ?>							
			<cite><strong><?php comment_author_link() ?> <?php if($isByAuthor ) { echo '(author)';} ?> </strong> on: </cite><?php comment_date('j F Y') ?> at <?php comment_time() ?><div class="left commentmetadata"></div>
			<div class="commenttext">
				<?php if ($comment->comment_approved == '0') : ?>
					<em>Your comment is awaiting moderation.</em>
				<?php endif; ?>
				<?php comment_text() ?>
			</div>		
			<div class="right">
				<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
			</div>
		</div>	
	<?php
}

//Write Panel provision for specifying image urls
function add_wp_elegance_img_urls($id) {
	    $awmp_edit = $_POST["wpelegance_edit"];
	    if (isset($awmp_edit) && !empty($awmp_edit)) {
		    $ThumbnailURL = $_POST["wpelegance_tn"];
		    $FeaturedImgURL = $_POST["wpelegance_fi"];		    

		    delete_post_meta($id, 'wpelegance_tn');
		    delete_post_meta($id, 'wpelegance_fi');		    

		    if (isset($ThumbnailURL) && !empty($ThumbnailURL)) {
			    add_post_meta($id, 'wpelegance_tn', $ThumbnailURL);
		    }		    
		    if (isset($FeaturedImgURL) && !empty($FeaturedImgURL)) {
			    add_post_meta($id, 'wpelegance_fi', $FeaturedImgURL);
		    }		    
	    }
	}
	
function wp_elegance_form_imageURLs() {
	    global $post;
		global $wp_version;
	    $post_id = $post;
	    if (is_object($post_id)) {
	    	$post_id = $post_id->ID;
	    }	    

	    $wpelegance_tn = htmlspecialchars(stripcslashes(get_post_meta($post_id, 'wpelegance_tn', true)));
	    $wpelegance_fi = htmlspecialchars(stripcslashes(get_post_meta($post_id, 'wpelegance_fi', true)));	    
		?>
				
		<?php if ((substr(wp_version, 0, 3) < '2.5')) { ?>
		<div class="dbx-b-ox-wrapper">
		<fieldset id="seodiv" class="dbx-box">
		<div class="dbx-h-andle-wrapper">
		<h3 class="dbx-handle"><?php _e('WP Elegance Theme') ?></h3>
		</div>
		<div class="dbx-c-ontent-wrapper">
		<div class="dbx-content">
		<?php } ?>

		<a target="__blank" href=" http://techblissonline.com/wpelegance-2-column-theme/"><?php _e('Click here for Support') ?></a>		
		<input value="wpelegance_edit" type="hidden" name="wpelegance_edit" />
		<table style="margin-bottom:40px">
		<tr>
		<th style="text-align:left;" colspan="2">
		</th>
		</tr>
		<tr>
		<th scope="row" style="text-align:right;"><?php _e('Thumbnail URL:') ?></th>
		<td><input value="<?php echo $wpelegance_tn ?>" type="text" name="wpelegance_tn" size="62"/></td>
		</tr>		
		<tr>
		<th scope="row" style="text-align:right;"><?php _e('Featured image URL:') ?></th>
		<td><input value="<?php echo $wpelegance_fi ?>" type="text" name="wpelegance_fi" size="62"/></td>
		</tr>		
		</table>		

		<?php if ((substr(wp_version, 0, 3) < '2.5')) { ?>
		</div>
		</fieldset>
		</div>
		<?php } ?>
		<?php  
	}

	function wp_elegance_admin_menu() {
		
		if( function_exists( 'add_meta_box' )) {
		    add_meta_box( 'postwpelegance', __( 'WP Elegance Theme' ), 
		                'wp_elegance_form_imageURLs', 'post', 'advanced' );
		    add_meta_box( 'postwpelegance', __( 'WP Elegance Theme'), 
		                'wp_elegance_form_imageURLs', 'page', 'advanced' );
		   } else {
		    add_action('dbx_post_advanced', 'wp_elegance_form_imageURLs' );
		    add_action('dbx_page_advanced', 'wp_elegance_form_imageURLs' );
		  }
	}
	
	add_action('edit_post', 'add_wp_elegance_img_urls');
	add_action('publish_post', 'add_wp_elegance_img_urls');
	add_action('save_post', 'add_wp_elegance_img_urls');
	add_action('edit_page_form', 'add_wp_elegance_img_urls');
	
	add_action('admin_menu', 'wp_elegance_admin_menu');

?>