<?php get_header(); ?>

	<div id="content">
	
	<?php if (have_posts()) : ?>
	
		<span class="breadcrumbs"><a href="<?php echo get_option('home'); ?>/">Home</a> &raquo; Archive</span>
	
 	<?php $post = $posts[0];?>

 	<?php /* Category archive */ if (is_category()) { ?><h2 class="title"> <?php single_cat_title(); ?> </h2>
    <?php do_action('get_psp_category_description'); ?><?php do_action('get_psp_category_keywords'); ?>
	<?php /* Tagged archive */ } elseif (is_tag()) { ?>	<h2 class="title">Articles tagged with: <?php single_tag_title(); ?></h2>

 	<?php /* Daily archive */ } elseif (is_day()) { ?>	<h2 class="title"> <?php the_time('j F Y'); ?></h2>

 	<?php /* Monthly archive */ } elseif (is_month()) { ?><h2 class="title"> <?php the_time('F Y'); ?></h2>
 	
	<?php /* Yearly archive */ } elseif (is_year()) { ?>
	<h2 class="title">Articles Archive for Year <?php the_time('Y'); ?></h2>

 	<?php /* Paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
	<h2 class="title">The Archives</h2>
 	 <?php } ?>

	<div id="archive">
		
	<?php while (have_posts()) : the_post(); ?>	
	<div class="clearfloat">	
	<div class="title"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></div>	
	<div class="stats">
		<span><?php edit_post_link('(Edit)', '', ''); ?></span>
		<span>Written By: <?php the_author() ?>&nbsp;on&nbsp;<?php the_time('F j, Y'); ?></span>		
		<span><?php comments_popup_link('No Comment', '1 Comment', '% Comments' );?></span>		
	</div>
	<div class="story">
	<?php if ( !get_option('wpe_thumbnail')) {?>
		<?php get_thumbnail($post->ID); ?>
	<?php } ?>
	<?php the_excerpt();?>	
	<a class="readmore right" href="<?php the_permalink(); ?>">more&rarr;</a>	
	</div>
	</div>
	<div class="tags"><small><?php the_tags( 'Tags: [', ', ', ']'); ?></small></div>

	<?php endwhile; ?>
	
	<div class="navigation">

	<?php if(function_exists('wp_pagenavi')) { wp_pagenavi(); } 
			else { ?>

			<div class="right"><?php next_posts_link('Next Page &rarr;') ?></div>
			<div class="left"><?php previous_posts_link('&larr; Previous Page') ?></div>
			<?php } ?>


	</div>
	
	<?php else : ?>
	
	<h2 class="title">No posts found. Try a different search?</h2>
	
	<?php endif; ?>

	</div>	
	</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
