<?php get_header(); ?>

<div id="content" class="clearfix row">

    <div id="main" class="col-sm-8 clearfix" role="main">

        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> role="article" itemscope itemtype="http://schema.org/BlogPosting">

            <header>

                <?php the_post_thumbnail( 'wpbo-featured' ); ?>

                <div class="page-header"><h1 class="single-title" itemprop="headline"><?php the_title(); ?></h1></div>

                <?php get_template_part('partials/content', 'meta');?>

            </header> <!-- end article header -->

            <section class="post_content clearfix" itemprop="articleBody">
                <?php the_content(); ?>

                <?php wp_link_pages(); ?>

                <?php get_template_part('partials/content','author'); ?>

            </section> <!-- end article section -->

            <footer>

                <?php the_tags('<p class="tags"><span class="tags-title">' . __("Tags","wpbo") . ':</span> ', ' ', '</p>'); ?>

            </footer> <!-- end article footer -->

        </article> <!-- end article -->

        <?php comments_template('',true); ?>

        <?php endwhile; ?>

        <?php else : ?>

        <article id="post-not-found">
            <header>
                <h1><?php _e("Not Found", "wpbo"); ?></h1>
            </header>
            <section class="post_content">
                <p><?php _e("Sorry, but the requested resource was not found on this site.", "wpbo"); ?></p>
            </section>
            <footer>
            </footer>
        </article>

        <?php endif; ?>

    </div> <!-- end #main -->

    <?php get_sidebar(); // sidebar 1 ?>

</div> <!-- end #content -->

<?php get_footer(); ?>
