<?php get_header(); ?>

<div id="content" class="clearfix row">

    <div id="main" class="col-sm-8 clearfix" role="main">

        <div class="page-header"><h1 class="archive_title h2">
            <span><?php _e("Posts By:", "wpbo"); ?></span>
            <?php
                // If google profile field is filled out on author profile, link the author's page to their google+ profile page
                $curauth = (get_query_var('author_name')) ? get_user_by('slug', get_query_var('author_name')) : get_userdata(get_query_var('author'));
                $google_profile = get_the_author_meta( 'google_profile', $curauth->ID );
                if ( $google_profile ) {
                    echo '<a href="' . esc_url( $google_profile ) . '" rel="me">' . $curauth->display_name . '</a>';
            ?>
            <?php
                } else {
                    echo get_the_author_meta('display_name', $curauth->ID);
                }
            ?>
        </h1></div>

        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> role="article">

            <header>

                <h3 class="h2"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>

                <?php get_template_part('partials/content', 'meta');?>

            </header> <!-- end article header -->

            <section class="post_content">

                <?php the_post_thumbnail( 'wpbo-featured' ); ?>

                <?php the_excerpt(); ?>

            </section> <!-- end article section -->

            <footer>

            </footer> <!-- end article footer -->

        </article> <!-- end article -->

        <?php endwhile; ?>

        <?php
            if (function_exists('wpbo_pagenavi')) { // function for pagination

                wpbo_pagenavi(); // use the page navi function

            } else { // if it is disabled, display regular wp prev & next links ?>
            <nav class="wp-prev-next">
                <ul class="pager">
                    <li class="previous"><?php next_posts_link(_e('&laquo; Older Entries', "wpbo")) ?></li>
                    <li class="next"><?php previous_posts_link(_e('Newer Entries &raquo;', "wpbo")) ?></li>
                </ul>
            </nav>
        <?php } ?>	

        <?php else : ?>

        <article id="post-not-found">
            <header>
                <h1><?php _e("No Posts Yet", "wpbo"); ?></h1>
            </header>
            <section class="post_content">
                <p><?php _e("Sorry, What you were looking for is not here.", "wpbo"); ?></p>
            </section>
            <footer>
            </footer>
        </article>

        <?php endif; ?>

    </div> <!-- end #main -->

    <?php get_sidebar(); // sidebar 1 ?>

</div> <!-- end #content -->

<?php get_footer(); ?>
