<?php

/**
 * Featured Settings
 *
 * @package WP Travel Magazine
 */
add_action( 'customize_register', 'wp_travel_magazine_customize_register_featured_lifestyle' );
function wp_travel_magazine_customize_register_featured_lifestyle( $wp_customize )
{
    $wp_customize->add_section( 'wp_travel_magazine_featured_lifestyle_sections', array(
        'title'       => esc_html__( 'Featured Section', 'wp-travel-magazine' ),
        'description' => esc_html__( 'Featured Section :', 'wp-travel-magazine' ),
        'panel'       => 'wp_travel_magazine_theme_options_panel',
    ) );
    $wp_customize->add_setting( 'featured_lifestyle_display_option', array(
        'sanitize_callback' => 'wp_travel_magazine_sanitize_checkbox',
        'default'           => true,
    ) );
    $wp_customize->add_control( new Wp_Travel_Magazine_Toggle_Control( $wp_customize, 'featured_lifestyle_display_option', array(
        'label'    => esc_html__( 'Hide / Show', 'wp-travel-magazine' ),
        'section'  => 'wp_travel_magazine_featured_lifestyle_sections',
        'settings' => 'featured_lifestyle_display_option',
        'type'     => 'toggle',
    ) ) );
    $wp_customize->selective_refresh->add_partial( 'featured_lifestyle_display_option', array(
        'selector' => '.featured-blog .container',
    ) );
    $wp_customize->add_setting( 'featured_lifestyle_category', array(
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_category',
        'default'           => '',
    ) );
    $wp_customize->add_control( new Wp_Travel_Magazine_Customize_Dropdown_Taxonomies_Control( $wp_customize, 'featured_lifestyle_category', array(
        'label'    => esc_html__( 'Choose Category', 'wp-travel-magazine' ),
        'section'  => 'wp_travel_magazine_featured_lifestyle_sections',
        'settings' => 'featured_lifestyle_category',
        'type'     => 'dropdown-taxonomies',
        'taxonomy' => 'category',
    ) ) );
    $wp_customize->add_setting( 'featured_lifestyle_section_title', array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => '',
    ) );
    $wp_customize->add_control( 'featured_lifestyle_section_title', array(
        'label'    => esc_html__( 'Title', 'wp-travel-magazine' ),
        'section'  => 'wp_travel_magazine_featured_lifestyle_sections',
        'settings' => 'featured_lifestyle_section_title',
        'type'     => 'text',
    ) );
    
    $wp_customize->add_setting( 'featured_fullwidth_option', array(
        'sanitize_callback' => 'wp_travel_magazine_sanitize_checkbox',
        'default'           => false,
    ) );
    $wp_customize->add_control( new Wp_Travel_Magazine_Toggle_Control( $wp_customize, 'featured_fullwidth_option', array(
        'label'    => esc_html__( 'Fullwidth Display?', 'wp-travel-magazine' ),
        'section'  => 'wp_travel_magazine_featured_lifestyle_sections',
        'settings' => 'featured_fullwidth_option',
        'type'     => 'toggle',
    ) ) );
    $wp_customize->add_setting( 'number_of_featured_posts', array(
        'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
        'default'           => '5',
    ) );
    $wp_customize->add_control( new Wp_Travel_Magazine_Select_Control( $wp_customize, 'number_of_featured_posts', array(
        'label'    => esc_html__( 'Number of posts', 'wp-travel-magazine' ),
        'section'  => 'wp_travel_magazine_featured_lifestyle_sections',
        'settings' => 'number_of_featured_posts',
        'type'     => 'select',
        'choices'  => array(
        '3'  => '3',
        '4'  => '4',
        '5'  => '5',
        '6'  => '6',
        '7'  => '7',
        '8'  => '8',
        '9'  => '9',
        '10' => '10',
    ),
    ) ) );
    $wp_customize->add_setting( 'featured_lifestyle_show_hide_details', array(
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_array',
        'default'           => array( 'date' )
    ) );
    $wp_customize->add_control( new Wp_Travel_Magazine_Multi_Check_Control( $wp_customize, 'featured_lifestyle_show_hide_details', array(
        'label'    => esc_html__( 'Hide / Show Details', 'wp-travel-magazine' ),
        'section'  => 'wp_travel_magazine_featured_lifestyle_sections',
        'settings' => 'featured_lifestyle_show_hide_details',
        'type'     => 'multi-check',
        'choices'  => array(
        'author'             => esc_html__( 'Show post author', 'wp-travel-magazine' ),
        'date'               => esc_html__( 'Show post date', 'wp-travel-magazine' ),
        'categories'         => esc_html__( 'Show Categories', 'wp-travel-magazine' ),
        'tags'               => esc_html__( 'Show Tags', 'wp-travel-magazine' ),
        'number_of_comments' => esc_html__( 'Show number of comments', 'wp-travel-magazine' ),
        'description'        => esc_html__( 'Show description', 'wp-travel-magazine' ),
        'read-more'          => esc_html__( 'Show Read More', 'wp-travel-magazine' ),
    ),
    ) ) );
}