<?php
/**
 * Headline Settings
 *
 * @package WP Travel Magazine
 */

add_action( 'customize_register', 'wp_travel_magazine_theme_headline_section' );

function wp_travel_magazine_theme_headline_section( $wp_customize ) {

    $wp_customize->add_section( 'wp_travel_magazine_theme_headline_section', array(
        'title'          => esc_html__( 'Headline Options', 'wp-travel-magazine' ),
        'panel'          => 'wp_travel_magazine_header_panel',
        'capability'     => 'edit_theme_options',
    ) );


    $wp_customize->add_setting( 'theme_headline_display_option', array(
        'sanitize_callback'     =>  'wp_travel_magazine_sanitize_checkbox',
        'default'               =>  true
    ) );
            
    $wp_customize->add_control( new Wp_Travel_Magazine_Toggle_Control( $wp_customize, 'theme_headline_display_option', array(
        'label' => esc_html__( 'Hide / Show Headline','wp-travel-magazine' ),
        'section' => 'wp_travel_magazine_theme_headline_section',
        'settings' => 'theme_headline_display_option',
        'type'=> 'toggle',
    ) ) );

    $wp_customize->selective_refresh->add_partial( 'theme_headline_display_option', array(
        'selector' => '.headline-ticker-wrapper .headline-wrapper',
    ) );


    $wp_customize->add_setting( 'headline_show_on_pages_option', array(
        'default' => 'show_on_all',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_select'
    ) );
     
    $wp_customize->add_control( 'headline_show_on_pages_option', array(
        'label' => esc_html__( 'Select to show on home or all pages.', 'wp-travel-magazine' ),
        'section' => 'wp_travel_magazine_theme_headline_section',
        'settings' => 'headline_show_on_pages_option',
        "active_callback" => function ($control) {
            return $control->manager->get_setting( "theme_headline_display_option" )->value();
        },
        'type' => 'radio',
        'choices' => array(
            'show_on_home' => esc_html__( 'Show only on Homepage', 'wp-travel-magazine' ),
            'show_on_all' => esc_html__( 'Show on all pages', 'wp-travel-magazine' ),
        )
    ) );


    $wp_customize->add_setting( 'headline_title', array(
        'sanitize_callback'     =>  'sanitize_text_field',
        'default'               =>  ''
    ) );

    $wp_customize->add_control( 'headline_title', array(
        'label' => esc_html__( 'Title', 'wp-travel-magazine' ),
        'section' => 'wp_travel_magazine_theme_headline_section',
        'settings' => 'headline_title',
        'type'=> 'text',
    ) );


    $wp_customize->add_setting( 'theme_headline_category', array(
        'capability'  => 'edit_theme_options',        
        'sanitize_callback' => 'wp_travel_magazine_sanitize_category',
        'default'     => '',
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Customize_Dropdown_Taxonomies_Control( $wp_customize, 'theme_headline_category', array(
        'label' => esc_html__( 'Choose Category', 'wp-travel-magazine' ),
        'section' => 'wp_travel_magazine_theme_headline_section',
        'settings' => 'theme_headline_category',
        'type'=> 'dropdown-taxonomies',
        'taxonomy'  =>  'category'
    ) ) );

    $wp_customize->add_setting( 'number_of_headline_posts', array(
        'sanitize_callback'     =>  'sanitize_text_field',
        'default'               =>  5
    ) );

    $wp_customize->add_control( 'number_of_headline_posts', array(
        'label' => esc_html__( 'Number of posts', 'wp-travel-magazine' ),
        'section' => 'wp_travel_magazine_theme_headline_section',
        'settings' => 'number_of_headline_posts',
        'type'=> 'text',
        'description'   =>  'put -1 for unlimited'
    ) );


}