<?php

/**
 * Pagination Settings
 *
 * @package WP Travel Magazine
 */


add_action( 'customize_register', 'wp_travel_magazine_customize_register_pagination_section' );
function wp_travel_magazine_customize_register_pagination_section( $wp_customize ) {

    $wp_customize->add_section( 'wp_travel_magazine_pagination_section', array(
        'title'          => esc_html__( 'Pagination', 'wp-travel-magazine' ),
        'description'    => esc_html__( 'Pagination :', 'wp-travel-magazine' ),
        'panel'          => 'wp_travel_magazine_general_panel',
        'priority'       => 4,        
    ) );
}

add_action( 'customize_register', 'wp_travel_magazine_customize_pagination' );

function wp_travel_magazine_customize_pagination( $wp_customize ) {

    $wp_customize->add_setting( 'pagination_type', array(
        'capability'  => 'edit_theme_options',        
        'sanitize_callback' => 'wp_travel_magazine_sanitize_choices',
        'default'     => 'ajax-loadmore',
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Radio_Buttonset_Control( $wp_customize, 'pagination_type', array(
        'label' => esc_html__( 'Pagination Type :', 'wp-travel-magazine' ),
        'section' => 'wp_travel_magazine_pagination_section',
        'settings' => 'pagination_type',
        'type'=> 'radio-buttonset',
        'choices'     => array(
            'ajax-loadmore' => esc_html__( 'Ajax Loadmore', 'wp-travel-magazine' ),
            'number-pagination'    =>  esc_html__( 'Number Pagination', 'wp-travel-magazine' ),      
        ),
    ) ) );            
    
}