<?php

/**
 * News Heading Settings
 *
 * @package WP Travel Magazine
 */

add_action( 'customize_register', 'wp_travel_magazine_customize_register_news_heading_colors_fonts' );
function wp_travel_magazine_customize_register_news_heading_colors_fonts( $wp_customize ) {

    $wp_customize->add_section( 'wp_travel_magazine_news_heading_section', array(
        'title'          => esc_html__( 'News Heading', 'wp-travel-magazine' ),
        'panel'          => 'wp_travel_magazine_colors_fonts_panel',
    ) );
}

add_action( 'customize_register', 'wp_travel_magazine_customize_news_header_fonts_colors' );
function wp_travel_magazine_customize_news_header_fonts_colors( $wp_customize ) {


    //Headline
    $wp_customize->add_setting( 'headline_news_title_fonts_colors_label', array(
        'sanitize_callback' => 'wp_kses_post',
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Custom_Text( $wp_customize, 'headline_news_title_fonts_colors_label', array(
        'settings'    => 'headline_news_title_fonts_colors_label',
        'label'       =>  '<div class="customizer-custom-label">' . esc_html__( "Headline News Title", 'wp-travel-magazine' ) . '</div>',
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'customtext',
    ) ) );

    $wp_customize->add_setting( 'headline_colors', array(
        'default'     => '#69c6a9',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'headline_colors', array(
        'label'      => esc_html__( 'Color', 'wp-travel-magazine' ),
        'section'    => 'wp_travel_magazine_news_heading_section',
        'settings'   => 'headline_colors',
    ) ) );

    $wp_customize->add_setting( 'headline_news_title_font_family', array(        
        'default'     => 'Reem Kufi',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_google_fonts',
    ) );

    $wp_customize->add_control( 'headline_news_title_font_family', array(
        'settings'    => 'headline_news_title_font_family',
        'label'       =>  esc_html__( 'Font Family', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'choices'     => wp_travel_magazine_google_fonts(),
    ) );

    $wp_customize->add_setting( 'headline_news_title_font_size', array(      
      'default'     => '14px',
      'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
    ) );
    
    $wp_customize->add_control( 'headline_news_title_font_size', array(
        'settings'    => 'headline_news_title_font_size',
        'label'       =>  esc_html__( 'Font Size', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'default'     => '14px',
        'choices'     =>  array(             
                        '13px' => '13px',
                        '14px' => '14px',
                        '15px' => '15px',
                        '16px' => '16px',
                        '17px' => '17px',
                        '18px' => '18px',
                        '19px' => '19px',
                        '20px' => '20px',
                        '21px' => '21px',
                        '22px' => '22px',
                        '23px' => '23px',
                        '24px' => '24px',
                        '25px' => '25px',
                        '26px' => '26px',
                        '27px' => '27px',
                        '28px' => '28px',
                        '29px' => '29px',
                        '30px' => '30px',
                    ),
      ) );

    $wp_customize->add_setting( 'headline_news_title_line_height', array(      
      'default'     => '16px',
      'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
    ) );
    
    $wp_customize->add_control( 'headline_news_title_line_height', array(
        'settings'    => 'headline_news_title_line_height',
        'label'       =>  esc_html__( 'Line Height', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'default'     => '13px',
        'choices'     =>  array(             
                        '13px' => '13px',
                        '14px' => '14px',
                        '15px' => '15px',
                        '16px' => '16px',
                        '17px' => '17px',
                        '18px' => '18px',
                        '19px' => '19px',
                        '20px' => '20px',
                        '21px' => '21px',
                        '22px' => '22px',
                        '23px' => '23px',
                        '24px' => '24px',
                    ),
      ) );


    $wp_customize->add_setting( 'headline_news_title_font_weight', array(
        'default'           => 200,
        'sanitize_callback' => 'absint',
        
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Slider_Control( $wp_customize, 'headline_news_title_font_weight', array(
        'section' => 'wp_travel_magazine_news_heading_section',
        'settings' => 'headline_news_title_font_weight',
        'label'   => esc_html__( 'Font Weight', 'wp-travel-magazine' ),
        'choices'     => array(
            'min'  => 100,
            'max'  => 900,
            'step' => 100,
        ),
    ) ) );





    // Featured
    $wp_customize->add_setting( 'featured_news_title_fonts_colors_label', array(
        'sanitize_callback' => 'wp_kses_post',
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Custom_Text( $wp_customize, 'featured_news_title_fonts_colors_label', array(
        'settings'    => 'featured_news_title_fonts_colors_label',
        'label'       =>  '<div class="customizer-custom-label">' . esc_html__( "Featured News Title", 'wp-travel-magazine' ) . '</div>',
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'customtext',
    ) ) );

    $wp_customize->add_setting( 'featured_news_title_colors', array(
        'default'     => '#fff',
        'transport'   => 'postMessage',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'featured_news_title_colors', array(
        'label'      => esc_html__( 'Color', 'wp-travel-magazine' ),
        'section'    => 'wp_travel_magazine_news_heading_section',
        'settings'   => 'featured_news_title_colors',
    ) ) );

    $wp_customize->add_setting( 'featured_news_title_font_family', array(
        
        'default'     => 'Reem Kufi',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_google_fonts',
    ) );

    $wp_customize->add_control( 'featured_news_title_font_family', array(
        'settings'    => 'featured_news_title_font_family',
        'label'       =>  esc_html__( 'Font Family', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'choices'     => wp_travel_magazine_google_fonts(),
    ) );

    $wp_customize->add_setting( 'featured_news_title_font_size', array(
      
      'default'     => '24px',
      'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
    ) );
    
    $wp_customize->add_control( 'featured_news_title_font_size', array(
        'settings'    => 'featured_news_title_font_size',
        'label'       =>  esc_html__( 'Font Size', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'default'     => '13px',
        'choices'     =>  array(             
                        '13px' => '13px',
                        '14px' => '14px',
                        '15px' => '15px',
                        '16px' => '16px',
                        '17px' => '17px',
                        '18px' => '18px',
                        '19px' => '19px',
                        '20px' => '20px',
                        '21px' => '21px',
                        '22px' => '22px',
                        '23px' => '23px',
                        '24px' => '24px',
                        '25px' => '25px',
                        '26px' => '26px',
                        '27px' => '27px',
                        '28px' => '28px',
                        '29px' => '29px',
                        '30px' => '30px',
                    ),
      ) );

    $wp_customize->add_setting( 'featured_news_title_line_height', array(
      
      'default'     => '30px',
      'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
    ) );
    
    $wp_customize->add_control( 'featured_news_title_line_height', array(
        'settings'    => 'featured_news_title_line_height',
        'label'       =>  esc_html__( 'Line Height', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'default'     => '13px',
        'choices'     =>  array(             
                        '13px' => '13px',
                        '14px' => '14px',
                        '15px' => '15px',
                        '16px' => '16px',
                        '17px' => '17px',
                        '18px' => '18px',
                        '19px' => '19px',
                        '20px' => '20px',
                        '21px' => '21px',
                        '22px' => '22px',
                        '23px' => '23px',
                        '24px' => '24px',
                        '25px' => '25px',
                        '26px' => '26px',
                        '27px' => '27px',
                        '28px' => '28px',
                        '29px' => '29px',
                        '30px' => '30px',
                    ),
      ) );


    $wp_customize->add_setting( 'featured_news_title_font_weight', array(
        'default'           => 200,
        'sanitize_callback' => 'absint',
        
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Slider_Control( $wp_customize, 'featured_news_title_font_weight', array(
        'section' => 'wp_travel_magazine_news_heading_section',
        'settings' => 'featured_news_title_font_weight',
        'label'   => esc_html__( 'Font Weight', 'wp-travel-magazine' ),
        'choices'     => array(
            'min'  => 100,
            'max'  => 900,
            'step' => 100,
        ),
    ) ) );



   

   
    $wp_customize->add_setting( 'blog_news_title_fonts_colors_label', array(
        'sanitize_callback' => 'wp_kses_post',
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Custom_Text( $wp_customize, 'blog_news_title_fonts_colors_label', array(
        'settings'    => 'blog_news_title_fonts_colors_label',
        'label'       =>  '<div class="customizer-custom-label">' . esc_html__( "Blog News Title", 'wp-travel-magazine' ) . '</div>',
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'customtext',
    ) ) );

    $wp_customize->add_setting( 'blog_colors', array(
        'default'     => '#7caab6',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_hex_color'
    ) );

    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'blog_colors', array(
        'label'      => esc_html__( 'Color', 'wp-travel-magazine' ),
        'section'    => 'wp_travel_magazine_news_heading_section',
        'settings'   => 'blog_colors',
    ) ) );

    $wp_customize->add_setting( 'blog_news_title_font_family', array(        
        'default'     => 'Reem Kufi',
        'sanitize_callback' => 'wp_travel_magazine_sanitize_google_fonts',
    ) );

    $wp_customize->add_control( 'blog_news_title_font_family', array(
        'settings'    => 'blog_news_title_font_family',
        'label'       =>  esc_html__( 'Font Family', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'choices'     => wp_travel_magazine_google_fonts(),
    ) );

    $wp_customize->add_setting( 'blog_news_title_font_size', array(      
      'default'     => '22px',
      'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
    ) );
    
    $wp_customize->add_control( 'blog_news_title_font_size', array(
        'settings'    => 'blog_news_title_font_size',
        'label'       =>  esc_html__( 'Font Size', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'default'     => '18px',
        'choices'     =>  array(             
                        '13px' => '13px',
                        '14px' => '14px',
                        '15px' => '15px',
                        '16px' => '16px',
                        '17px' => '17px',
                        '18px' => '18px',
                        '19px' => '19px',
                        '20px' => '20px',
                        '21px' => '21px',
                        '22px' => '22px',
                        '23px' => '23px',
                        '24px' => '24px',
                        '25px' => '25px',
                        '26px' => '26px',
                        '27px' => '27px',
                        '28px' => '28px',
                        '29px' => '29px',
                        '30px' => '30px',
                    ),
      ) );

    $wp_customize->add_setting( 'blog_news_title_line_height', array(      
      'default'     => '30px',
      'sanitize_callback' => 'wp_travel_magazine_sanitize_select',
    ) );
    
    $wp_customize->add_control( 'blog_news_title_line_height', array(
        'settings'    => 'blog_news_title_line_height',
        'label'       =>  esc_html__( 'Line Height', 'wp-travel-magazine' ),
        'section'     => 'wp_travel_magazine_news_heading_section',
        'type'        => 'select',
        'default'     => '22px',
        'choices'     =>  array(             
                        '13px' => '13px',
                        '14px' => '14px',
                        '15px' => '15px',
                        '16px' => '16px',
                        '17px' => '17px',
                        '18px' => '18px',
                        '19px' => '19px',
                        '20px' => '20px',
                        '21px' => '21px',
                        '22px' => '22px',
                        '23px' => '23px',
                        '24px' => '24px',
                        '25px' => '25px',
                        '26px' => '26px',
                        '27px' => '27px',
                        '28px' => '28px',
                        '29px' => '29px',
                        '30px' => '30px',
                    ),
      ) );


    $wp_customize->add_setting( 'blog_news_title_font_weight', array(
        'default'           => 400,
        'sanitize_callback' => 'absint',
        
    ) );

    $wp_customize->add_control( new Wp_Travel_Magazine_Slider_Control( $wp_customize, 'blog_news_title_font_weight', array(
        'section' => 'wp_travel_magazine_news_heading_section',
        'settings' => 'blog_news_title_font_weight',
        'label'   => esc_html__( 'Font Weight', 'wp-travel-magazine' ),
        'choices'     => array(
            'min'  => 100,
            'max'  => 900,
            'step' => 100,
        ),
    ) ) );
    

    
}