<?php
if ( function_exists('register_sidebar') )
    register_sidebar(array(
        'before_widget' => '<li id="%1$s" class="widget %2$s">',
        'after_widget' => '</li>',
        'before_title' => '<h2 class="widgettitle">',
        'after_title' => '</h2>',
    ));

add_filter('comments_template', 'legacy_comments');
function legacy_comments($file) {
	if(!function_exists('wp_list_comments')) 	$file = TEMPLATEPATH . '/legacy.comments.php';
	return $file;
}
?>
<?php
$themename = "Wp Soul Theme";
$shortname = "ts";
$options = array (
	array(	"name" => "Header logo settings",
			"type" => "heading"),
	array(	"name" => "Show image logo?",
			"desc" => "Check this box if you want to show image logo in header.<br /><br />",
			"id" => $shortname."_logo_check",
			"std" => "false",
            "type" => "checkbox"),
	array(  "name" => "Logo image path",
            "id" => $shortname."_logo_image",
            "std" => "",
			"desc" => "Enter your logo image path here.<br /><br />",
            "type" => "text"),
	array(	"name" => "Sidebar 125 x 125 Ads",
			"type" => "heading"),
    array(	"name" => "Show sidebar ads?",
			"desc" => "Check this box if you want to show sidebar ads.<br /><br />",
			"id" => $shortname."_ad_check",
			"std" => "false",
            "type" => "checkbox"),
	array(	"name" => "Ad 1 Image",
			"id" => $shortname."_ad1",
			"std" => "",
            "desc" => "Insert the image path for the banner (125x125 pixels)",
			"type" => "text"),
	array(	"name" => "Ad 1 Link",
			"id" => $shortname."_ad1_link",
			"std" => "#",
            "desc" => "Insert link for the banner.<br /><br />",
			"type" => "text"),
	array(	"name" => "Ad 2 Image",
			"id" => $shortname."_ad2",
			"std" => "",
            "desc" => "Insert the image path for the banner (125x125 pixels)",
			"type" => "text"),
	array(	"name" => "Ad 2 Link",
			"id" => $shortname."_ad2_link",
			"std" => "#",
            "desc" => "Insert link for the banner.<br /><br />",
			"type" => "text"),
	array(	"name" => "Ad 3 Image",
			"id" => $shortname."_ad3",
			"std" => "",
            "desc" => "Insert the image path for the banner (125x125 pixels)",
			"type" => "text"),
	array(	"name" => "Ad 3 Link",
			"id" => $shortname."_ad3_link",
			"std" => "#",
            "desc" => "Insert link for the banner.<br /><br />",
			"type" => "text"),
	array(	"name" => "Ad 4 Image",
			"id" => $shortname."_ad4",
			"std" => "",
            "desc" => "Insert the image path for the banner (125x125 pixels)",
			"type" => "text"),
	array(	"name" => "Ad 4 Link",
			"id" => $shortname."_ad4_link",
			"std" => "#",
            "desc" => "Insert link for the banner.<br /><br />",
			"type" => "text"),
	array(	"name" => "RSS form and button settings",
			"type" => "heading"),
	array(	"name" => "Show RSS box?",
			"desc" => "Check this box if you want to show RSS box.<br /><br />",
			"id" => $shortname."_rss_check",
			"std" => "false",
            "type" => "checkbox"),
	array(  "name" => "Feedburner URL",
            "id" => $shortname."_feed_url",
            "std" => "?feed=rss2",
			"desc" => "Enter your feedburner feed url or leave it for default feed address.<br /><br />",
            "type" => "text"),
	array(  "name" => "Feedburner Title",
            "id" => $shortname."_feed_name",
            "std" => "",
			"desc" => "Enter your feedburner feed title (needed for e-mail subscription form).<br /><br />",
            "type" => "text"),
	array(  "name" => "RSS feed info text",
            "id" => $shortname."_feed_text",
            "std" => "You can subscribe to <b>RSS</b> in Feed Reader or you can receive blog updates via <b>E-mail</b>, New posts straight to your inbox. Use Subscription form below.",
			"desc" => "If you want to change info text in RSS box then type above.<br /><br />",
            "type" => "text"),
	array(	"name" => "Twitter button settings",
			"type" => "heading"),
	array(	"name" => "Show twitter button?",
			"desc" => "Check this box if you want to show twitter follow us button in the sidebar.<br /><br />",
			"id" => $shortname."_twitter_check",
			"std" => "false",
            "type" => "checkbox"),
	array(  "name" => "Your twitter name",
            "id" => $shortname."_twitter_name",
            "std" => "",
			"desc" => "Enter your Twitter name.<br /><br />",
            "type" => "text"),
	array(	"name" => "Author info box",
			"type" => "heading"),
	array(	"name" => "Show Author info?",
			"desc" => "Check this box if you want to show author info box.<br /><br />",
			"id" => $shortname."_author_check",
			"std" => "false",
            "type" => "checkbox"),
	array(  "name" => "Author info",
            "id" => $shortname."_author_info",
            "std" => "This is <b>Author info Box</b> you can put something about yourself here like what you do and what your blog is all about. If you want to remove this info box or want to edit this info go to your Admin Dashboard, under Themes menu find <b>WP Soul Theme Options</b>. Further more you can control sidebar ads, header logo, RSS button and Twitter Button setting from theme options menu.",
			"desc" => "Enter something about yourself and your blog.<br /><br />",
            "type" => "text"),
		array(	"name" => "Social Icons Box",
			"type" => "heading"),
	array(	"name" => "Show social icons?",
			"desc" => "Check this box if you want to show social icons box under every post.<br /><br />",
			"id" => $shortname."_social_check",
			"std" => "false",
            "type" => "checkbox"),
	array(  "name" => "Text above social icons",
            "id" => $shortname."_social_text",
            "std" => "If you like this post then consider sharing it with others.",
			"desc" => "You can put your own text above social icons.<br /><br />",
            "type" => "text"),
);
function mytheme_add_admin() {
	global $themename, $shortname, $options;
	if ( $_GET['page'] == basename(__FILE__) ) {
		if ( 'save' == $_REQUEST['action'] ) {
				foreach ($options as $value) {
					update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }
				foreach ($options as $value) {
					if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
				header("Location: themes.php?page=functions.php&saved=true");
				die;
		} else if( 'reset' == $_REQUEST['action'] ) {
			foreach ($options as $value) {
				delete_option( $value['id'] ); }
			header("Location: themes.php?page=functions.php&reset=true");
			die;
		}
	}
    add_theme_page($themename." Options", "WP Soul Theme Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');
}
function mytheme_admin() {
	global $themename, $shortname, $options;
	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
?>
<div class="wrap">
<h2><?php echo $themename; ?> settings</h2>
<form method="post">
<table class="optiontable">
<?php foreach ($options as $value) {
if ($value['type'] == "text") {  ?>
<tr valign="top">
	<th scope="row"><?php echo $value['name']; ?>:</th>
	<td>
		<input style="width:500px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" />
        <br /><?php echo $value['desc']; ?>
    </td>
</tr>
<?php } elseif ($value['type'] == "textarea") {  ?>
<tr valign="top">
	<th scope="row"><?php echo $value['name']; ?>:</th>
	<td>
				<textarea style="width:500px;height:100px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" ><?php
				if( get_settings($value['id']) != "") {
						echo stripslashes(get_settings($value['id']));
					}else{
						echo $value['std'];
				}?></textarea>
        <br /><?php echo $value['desc']; ?>
	</td>
</tr>
<?php } elseif ($value['type'] == "checkbox") {  ?>
<tr valign="top">
	<th scope="row"><?php echo $value['name']; ?></th>
	<td>
	    <?php if(get_settings($value['id'])){
		    $checked = "checked=\"checked\"";
			    }else{
			$checked = "";
				}
		?>
		    <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
        <?php echo $value['desc']; ?>
	</td>
</tr>
<?php } elseif ($value['type'] == "heading") {  ?>
<tr valign="top">
	<th scope="row"></th>
	<td>
        <h3><?php echo $value['name']; ?></h3>
	</td>
</tr>
<?php
}
}
?>
</table>
<br />
<strong><text style="color:red">WP Soul a free quality theme was brought to you by</text> <a href="http://www.techiesouls.com/">TechieSouls.com</a>.</strong>
<p class="submit">
<input name="save" type="submit" value="Save changes" />
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>
<?php
}
add_action('admin_menu', 'mytheme_add_admin');
?>