<?php
/**
 * The template for displaying Search Results pages
 *
 */
global $m25_widgets;
global $m25_lang;
global $wp_query;
get_header(); ?>

<div class="content-area"> <!-- is closed in footer -->
   <div class="content-area-main <?php echo $m25_widgets->css_class_content_area_sidebar(); ?>">
      <div class="content-searchresult">
         <?php $total_results = $wp_query->found_posts;
         switch ( $total_results ) {
            case 0: esc_html_e( 'No search results for', 'wp-media-twentyfive' );
            break;
            default: printf( _n( 'One searchresult for', '%d searchresults for', $total_results, 'wp-media-twentyfive' ), number_format_i18n( $total_results ) );
            break;
         }
         echo " "; 
         the_search_query();
         get_search_form(); ?>
      </div> <!--content-searchresult-->
      <?php if ( have_posts() ) {
         while ( have_posts() ) {
            the_post();
            $post_id = get_the_ID();?>
            <div class="content-post">
               <div id="post-<?php the_ID() ?>" <?php post_class() ?>>
                  <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php esc_html_e('Permanent Link to', 'wp-media-twentyfive'); ?> <?php the_title_attribute(); ?>"><?php the_title( '<h1>', '</h1>' ); ?></a>
                  <?php $my_excerpt = get_the_excerpt();
                  if ( '' != $my_excerpt ) {
                    $my_excerpt = strip_tags( $my_excerpt );
                  }
                  echo $my_excerpt; ?>
               </div> <!--post-...-->
            </div> <!--content-post-->
        <?php } // end while
         $m25_content->display_navlinks();   
      }// end if
      ?>
   </div> <!--content-area-main-->
   <?php get_sidebar(); ?>
   
   <?php get_footer(); ?>