<?php 
global $m25_lang;
global $post_id; 
  
$comments_num = 0;
if ( have_comments() ) { //have_comments only works after calling comments_template!  ?>
   <div class="m25-comment-area">
      <?php $comments_num = get_comments( array( 'status' => 'approve', 'count' => 1, 'post_id' => $post_id ) ); ?>
      <span class="m25-comment-number">
      <?php printf( _n( 'One comment', '%s comments', $comments_num, 'wp-media-twentyfive' ), number_format_i18n( $comments_num ) ); ?>
      </span>
      <?php if ( ! isset($wp_query->query_vars['m25Comment'])) {
         $comments = get_comments( array( 'status' => 'approve', 'number' => 1, 'post_id' => $post_id ) ); 
      } else {
         $comments = get_comments( array( 'status' => 'approve', 'post_id' => $post_id) ); 
      }
      foreach ( $comments as $comment ) {?> 
         <div <?php comment_class( 'm25-comment', $comment->comment_ID ); ?>> 
            <?php if ( ! isset($wp_query->query_vars['m25Comment']) ) {
               comment_excerpt( $comment->comment_ID );
            } else { //full text
               echo $comment->comment_content ; 
            }?>
            <div class="m25-comment-meta">
               <span class="m25-comment-author">
                  <?php _ex( 'by', 'text was written BY author xy', 'wp-media-twentyfive' );
                  echo ' '.get_avatar( $comment, 32 ).$comment->comment_author.' '; ?>
               </span> 
               <span class="m25-comment-date">
                  <?php printf ( _x( 'at %s', 'text was written AT date', 'wp-media-twentyfive'), date_i18n( get_option( 'date_format' ), strtotime( get_the_date(  ) ) ) ) ; ?>
               </span>
            </div> <!--m25-comment-meta-->
         </div> <!--m25-comment-->
      <?php } //foreach
      //show link for comment form and comments > 1
      if ( ! isset($wp_query->query_vars['m25Comment']) ) { 
         if ( comments_open() ) { //commenting enabled ?>
            <div class="m25-comment-more">
               <a href="<?php echo add_query_arg( 'm25Comment', 'more', get_permalink()) ?>"><?php _e( 'more comments and answers', 'wp-media-twentyfive'); ?></a> 
            </div> <!--m25-comment-more-->   
         <?php } else { 
            if ( 1 < $comments_num ) { ?>
               <div class="m25-comment-more">
                  <a href="<?php echo add_query_arg( 'm25Comment', 'more', get_permalink()) ?>"><?php _e( 'more comments', 'wp-media-twentyfive'); ?></a> 
               </div> <!--m25-comment-more--> 
            <?php } 
         } //if comments_open 
      } else {
         if ( comments_open() ) { //commenting enabled ?>
            <a href="<?php echo get_permalink() ?>"><?php _x( 'back', 'verb', 'wp-media-twentyfive'); ?></a>
            <?php comment_form();        
         } else { ?>
            <div class="m25-comment-status">
               <?php _e( 'commenting closed', 'wp-media-twentyfive'); ?>
            </div> <!--m25-comment-status-->
            <a href="<?php echo get_permalink() ?>"><?php _x( 'back', 'verb', 'wp-media-twentyfive'); ?></a>
         <?php } //if comments_open
      } //if isset?>
   </div> <!--m25-comment-area-->
<?php } else { 
   if ( comments_open() ) {?>
      <div class="m25-comment-area">
         <span class="m25-comment-number">
            <?php _e( 'until now no comments', 'wp-media-twentyfive'); ?>
         </span>
         <?php //show link for comment form 
         if ( ! isset($wp_query->query_vars['m25Comment']) ) { ?>
            <div class="m25-comment-more">
               <a href="<?php echo add_query_arg( 'm25Comment', 'more', get_permalink()) ?>"><?php _e( 'leafe the first comment', 'wp-media-twentyfive'); ?></a> 
            </div> <!--m25-comment-more-->  
         <?php } else {?>
            <a href="<?php echo get_permalink() ?>"><?php _e( 'back', 'wp-media-twentyfive'); ?></a>
            <?php comment_form(); ?>
            <div class="m25-link-pages">
               <?php $m25_content->display_comments_page_link(); ?>
            </div> <!--m25-link-pages-->
         <?php } ?>
      </div> <!--m25-comment-area-->  
   <?php } //if comments_open
} ?>    

