/* global m25StyleHandle 
          m25ContentWidthID 
          m25CookieHandle
          m25Modes
          m25ScreenSelectorID
          m25ModeAuto
          m25ActualMode
          m25Images 
          m25CssPath */

if (m25ModeAuto == "auto"){
  jQuery(document).ready( function (){
    m25_set_mode();
    m25SwitchSize(m25ActualMode,"no");
  });
}

jQuery(window).resize(
  function(){
    if (m25ModeAuto == "auto"){
      m25_set_mode();
      m25SwitchSize(m25ActualMode,"no");
    }
  }
);

// returns the appropiate mode to the actual window-wdth
function m25_set_mode(){
var width;
var set_mode = "";
width = jQuery(window).width();

for (var index in m25Modes) {
  if (m25Modes.hasOwnProperty(index)){
    var mode = m25Modes[index];
    if (width >= mode.min){
      if (set_mode == ""){
        set_mode = mode.name;
      } else if (mode.min > m25Modes[set_mode].min){
        set_mode = mode.name;
      } 
    } 
  }
}
m25ActualMode = set_mode.toString();
}

// main function called from html-bar
function m25SwitchSize( modus, clicked ){
  switch( modus ) {
  case "auto":
    m25_switch_auto();
    break;
  default:
    changeSize( modus, clicked );
  }
}

function m25_switch_auto(){
  if (m25ModeAuto == "auto"){
    m25ModeAuto = "off";
    jQuery.cookie(m25CookieHandleAuto, "off", { path: '/' } );
    jQuery("#m25-auto").removeClass("active");
  } else {
    m25ModeAuto = "auto";
    jQuery.cookie(m25CookieHandleAuto, "auto", { path: '/' } );
    jQuery("#m25-auto").addClass("active");
    m25_set_mode();
    m25SwitchSize(m25ActualMode,"no");
  }  
}

function m25_turn_auto_off(){
  m25ModeAuto = "off";
  jQuery.cookie(m25CookieHandleAuto, "off", { path: '/' } );
  jQuery("#m25-auto").removeClass("active");
}

// main switch-function. Do actions depending on selected size
// param size = auto,s,l,m,...
function changeSize( size, clicked ){
  jQuery.cookie( m25CookieHandle, size, { path: "/" } );
  jQuery( "#"+m25StyleHandle+"-css" ).attr( "href", m25CssPath + "/" + size + ".css" );
  jQuery( "#"+m25ContentWidthID ).html( ".content-area { width: "+m25Modes[size].width+"px; margin: 0 auto;}" );
  switchImagesOnModes(size);
  jQuery( "#"+m25ScreenSelectorID ).find("a").removeClass("active");
  jQuery( "#m25-"+size ).addClass( "active" );
  if ( "yes" == clicked ) {
    m25_turn_auto_off();
  } else {
    if ( "auto" == m25ModeAuto ) {
      jQuery( "#m25-auto" ).addClass( "active" );
    }
  }
}

// switch images in the html-body depending on mode
// param mode = s,m,l,...
function switchImagesOnModes(mode){
  var imageSize, imageWidth, imageHeight, imageObject
      imageSRC = "";
  
  if ( jQuery.isEmptyObject( m25Images ) ){
    return;
  } else {
    for ( var imageID in m25Images ) {
      if ( m25Images.hasOwnProperty( imageID ) ){
        if ( 0 < jQuery( "#"+imageID ).length ){
          imageObject = m25Images[imageID][mode];
          imageWidth = imageObject.width;
          imageHeight = imageObject.height;
          imageSRC = imageObject.html;
          jQuery( "#"+imageID ).attr( "src", imageSRC );
          jQuery( "#"+imageID ).attr( "width", imageWidth );
          jQuery( "#"+imageID ).attr( "height", imageHeight );
        }
      } 
    } 
  }
}
