<?php
class M25_Widgets
{   
   protected $number_of_sidebars = 0; 
   protected $number_of_active_sidebars = 0;
   protected $sidebars;
   protected $widgetareas;
   protected $language_class;
   protected $content_area_without_sidebars_class;
   protected $content_area_with_sidebars_class;
   
   /*dont call the __()-function for internationalization here! Call it in the widgets_init-hook!*/
   public function __construct( &$lang_class ){
   	  add_action( 'widgets_init', array( $this, 'init_sidebars' ) , 1 ); //priority=1 call this function first
      add_action( 'widgets_init', array( $this, 'set_up_sidebars' ) );  
      add_action( 'widgets_init', array( $this, 'set_up_widget_areas' ) );
      
      $this->content_area_without_sidebars_class = "no_sidebars";
      $this->content_area_with_sidebars_class = "sidebars";
      $this->language_class = $lang_class; 
   } 
   
   public function init_sidebars(){
   	  $this->sidebars = array (
   			'm25-sidebar-a' => array (
   					'name'        => esc_html__( 'sidebar A', 'wp-media-twentyfive' ),
   					'description' => esc_html__( 'The sidebar A is located on the right site of the webpage and can contain widgets.', 'wp-media-twentyfive' ),
   			),
   	  );

   	  $this->widgetareas = array (
   			'm25-footer' => array (
   					'name'        => esc_html__( 'Footer widget area', 'wp-media-twentyfive' ),
   					'description' => esc_html__( 'The footer area is located under the footer menu.', 'wp-media-twentyfive' ),
   					'location'    => 'footer',
   					'class'       => 'm25-footer-widget',
   			),
   			'm25-top' => array (
   					'name'          => esc_html__( 'Top widget area', 'wp-media-twentyfive' ),
   					'description'   => esc_html__( 'The top widget area is located under the top menue before the content of the loop.', 'wp-media-twentyfive' ),
   					'location'      => 'top',
   					'class'         => 'm25-top-widget',
   					'before_widget' => '',
   					'after_widget'  => '',
   			),
   	  );
   }
   
   public function set_up_sidebars(){
      $args = array (
         'id' => '',
         'name' => '',
         'description' => '',
      );
      
      reset ( $this->sidebars );
      while ( $sidebar = current( $this->sidebars ) ) {
         $args['id'] = trim( key( $this->sidebars ) );
         $args['name'] = $sidebar['name'];
         $args['description'] =  $sidebar['description'];
         register_sidebar( $args );
         $this->number_of_sidebars += 1;
         
         next( $this->sidebars );
      }   
   }
   
   public function set_up_widget_areas() {
      $args = array ();
      
      reset ( $this->widgetareas );
      while ( $widgetarea = current( $this->widgetareas ) ) {
         $args['id'] = trim( key( $this->widgetareas ) );
         $args['name'] = $widgetarea['name'];
         $args['description'] = $widgetarea['description'];
         $args['class'] = $widgetarea['class'];
         if ( array_key_exists( 'before_widget', $widgetarea ) ) $args['before_widget'] = $widgetarea['before_widget'];
         if ( array_key_exists( 'after_widget', $widgetarea ) ) $args['after_widget'] = $widgetarea['after_widget'];
         register_sidebar( $args );
         
         next( $this->widgetareas );
      }   
   }
   
   public function get_number_of_sidebars() {
      return $this->number_of_sidebars;
   }
   
   public function get_number_of_active_sidebars() {
      reset ( $this->sidebars );
      $this->number_of_active_sidebars = 0;
      
      while ( $sidebar = current( $this->sidebars ) ) {
         $sidebar_id = trim( key( $this->sidebars ) );  
         if ( true == is_active_sidebar( $sidebar_id ) ) {
            $this->number_of_active_sidebars += 1;
         } 
         next( $this->sidebars );
      } //while
      
      return $this->number_of_active_sidebars;
   }
   
   public function display_sidebars() {
      reset ( $this->sidebars );
        
      while ( $sidebar = current( $this->sidebars ) ) {
         $sidebar_id = trim( key( $this->sidebars ) );  
          
         if ( true == is_active_sidebar( $sidebar_id ) ) {
            dynamic_sidebar( $sidebar_id );
         } else {
            printf( '<!-- '.esc_html__( 'Sidebar %s contains no widgets', 'wp-media-twentyfive' ).' -->', $sidebar_id );
         }
         next( $this->sidebars );
      } //while
   } 
   
   public function display_widget_area( $location ) {
      reset ( $this->widgetareas );
      
      while ( $widget_area = current( $this->widgetareas ) ) {
         $widget_location = $widget_area['location']; 
         
         if ( $widget_location == $location ) {
            $widgetarea_id = trim( key( $this->widgetareas ) );
            if ( true == is_active_sidebar( $widgetarea_id ) ) {
               dynamic_sidebar( $widgetarea_id );
            }
         } 
         next( $this->widgetareas );
      } //while
   }
   
   /* this function adds additional css-class depending on a visible or unvisible sidebar */
   public function css_class_content_area_sidebar ( ) {
   	  if ( 0 < $this->get_number_of_active_sidebars() ) {
         return $this->content_area_with_sidebars_class;
   	  } else {
   	  	 return $this->content_area_without_sidebars_class;
   	  }
   }
} //class
?>