<?php
class M25_Screen_Switcher
{   
   public $actual_width; /*inner width?*/
   public $actual_mode; /*s,l,m,...*/
   public $actual_mode_auto; /*on, off*/
   public $style_handle = 'media25-size';
   public $content_width_id = 'm25-content-width';
   public $screen_selector_id = 'm25-screen-selector';
   public $cookie_handle = 'm25-mode';
   public $cookie_handle_auto = 'm25-mode_auto';
   protected $css_pfad = '/css'; 
   protected $modes;  /*name, css, width-range*/
   protected $default_mode;
   protected $mode_at_last_call;
   
   public function __construct(){
      add_action( 'wp_head', array( $this, 'init_vars' ),1 ); /* Variablen vor Script-Einbindung definieren! */
      add_action( 'wp_head', array( $this, 'print_viewport' ) );
      add_action( 'wp_head', array( $this, 'print_style_content_width' ) );
      add_action( 'wp_enqueue_scripts', array( $this, 'register_stylesheet_for_head' ) );
    
      $this->modes=array (
      		'auto' => array('css' => '/l.css','width' => '0', 'min' => '0'),
      		's'    => array('css' => '/s.css','width' => '350', 'min' => '1', 'wp_image_size' => 'thumbnail'),
      		'm'    => array('css' => '/m.css','width' => '630', 'min' => '640', 'wp_image_size' => 'medium'),
      		'l'    => array('css' => '/l.css','width' => '980', 'min' => '1000', 'wp_image_size' => 'large'),
      );
      $this->default_mode = 'l';
      $this->actual_mode = 'auto';
      $this->mode_at_last_call = '';
   } 
   
   public function get_imagesize4mode(){
      $imagesize = '';
      $imagesize = $this->modes[$this->actual_mode]['wp_image_size'];
      return $imagesize;
   }
  
   public function get_style_uri4mode( $mode ){
      $uri = get_template_directory_uri().$this->css_pfad.$this->modes[$mode]['css'];
      return $uri;
   }
  
   public function get_width4mode( $mode ){
      $width = $this->modes[$mode]['width'];
      return $width;
   }
  
   public function get_actual_width(){
      $width = $this->modes[$this->actual_mode]['width'];
      return $width;
   }
  
   public function get_min4mode( $mode ){
      $width = $this->modes[$mode]['min'];
      return $width;
   }
  
   /**
     * Prints global variables for Javascript in the head of html-output. Must be printed first.
     *
     * @since x.x.x
     */
   public function init_vars(){
      if ( isset( $_COOKIE[ $this->cookie_handle ] ) ){
         $mode = $_COOKIE[ $this->cookie_handle ];
         $this->actual_mode = $mode;
      } else {
         $this->actual_mode = $this->default_mode;
      }
      
      if ( isset( $_COOKIE[ $this->cookie_handle_auto ] ) ){
         $mode = $_COOKIE[ $this->cookie_handle_auto ];
         $this->actual_mode_auto = $mode;
      } else {
         $this->actual_mode_auto = 'auto';
      }
      
      $html='
<script type="text/javascript">
/* <![CDATA[ */
var m25ActualMode = "'.$this->actual_mode_auto.'",
    m25ModeAuto = "'.$this->actual_mode_auto.'",
    m25StyleHandle = "'.$this->style_handle.'",
    m25CookieHandle = "'.$this->cookie_handle.'",
    m25CookieHandleAuto = "'.$this->cookie_handle_auto.'",
    m25ContentWidthID = "'.$this->content_width_id.'",
    m25ScreenSelectorID = "'.$this->screen_selector_id.'",
    m25Modes = {};
    m25Images = {};
    m25CssPath = "'.get_template_directory_uri().$this->css_pfad.'";
    
function m25Mode( name, css, width, min ) {
   this.name = name;
   this.css = css;
   this.width = width;
   this.min = min;
}
    		
function m25ConstructImage( mode, image, width, height ) {
   this.mode = mode;
   this.html = image;
   this.width = width;
   this.height = height;
}';
       
      reset ( $this->modes );
      while ( $element = current( $this->modes ) ) {
         $html .= 'm25Modes["'.trim( key( $this->modes ) ).'"] = new m25Mode("'.trim( key( $this->modes ) ).'","'.$element['css'].'",'.$element['width'].','.$element['min'].');';
         next( $this->modes );
      }
      
      $html .= 'm25Images["m25-post-image-1"] = {};'; //fill the array later   
      
      $html .= ' 
/* ]]> */
</script>';
      echo $html."\r\n";
   }

   /**
    * Adds images for Javascript.
    *
    * @since x.x.x
    */
   public function add_image_vars($id){
      $html='<script type="text/javascript"> /* <![CDATA[ */ ';
      
      reset ( $this->modes );
      next( $this->modes ); //skip first entry (=auto)
      $html .= 'm25Images["m25-post-image-'.$id.'"] = {};';
      while ( $element = current( $this->modes ) ) {
      	$image_src = wp_get_attachment_image_src( get_post_thumbnail_id($id), $element['wp_image_size'] );
      	$html .= 'm25Images["m25-post-image-'.$id.'"]["'.trim( key( $this->modes ) ).'"] = new m25ConstructImage("'.trim( key( $this->modes ) ).'","'.$image_src[0].'",'.$image_src[1].','.$image_src[2].');';
      	next( $this->modes );
      }
      
   	  $html .= '/* ]]> */ </script>';
      echo $html."\r\n";
   }
   
   public function print_style_content_width(){
      $html='
<style type="text/css" id="'.$this->content_width_id.'">
.content-area {
  width: '.$this->modes[$this->actual_mode]['width'].'px;
  margin: 0 auto;
}
</style>';
      echo $html."\r\n";
   }
   
   public function print_viewport(){
      $html='<meta name="viewport" id="viewport" content="width=device-width, initial-scale=1" />';
      echo $html."\r\n";
   }
   
   public function print_screen_selector(){
      $hyphen = "'";
      $html ='<div id="'.$this->screen_selector_id.'" class="screen-selector">'."\r\n".'<ul>'."\r\n";
      
      reset ($this->modes);
      while ($dummy = current($this->modes)) {
         if ((key($this->modes) == $this->actual_mode_auto) or (key($this->modes) == $this->actual_mode)){
            $html .= '<li><a href="#" id="m25-'.key($this->modes).'" class ="active" onclick="javascript:m25SwitchSize('.$hyphen.key($this->modes).$hyphen.','.$hyphen.'yes'.$hyphen.')">'.mb_strtoupper(key($this->modes)).'</a></li>'."\r\n";
         } else {
            $html .= '<li><a href="#" id="m25-'.key($this->modes).'" onclick="javascript:m25SwitchSize('.$hyphen.key($this->modes).$hyphen.','.$hyphen.'yes'.$hyphen.')">'.mb_strtoupper(key($this->modes)).'</a></li>'."\r\n";
         }
         next($this->modes);
      }
      
     $html .='</ul>'."\r\n".'</div> <!--screen-selector-->'."\r\n";
     echo $html."\r\n";
   }
   
   public function register_stylesheet_for_head(){
   
      if (isset($_COOKIE[$this->cookie_handle])){
          $mode = $_COOKIE[$this->cookie_handle];
      } else {
         $mode = $this->default_mode;
      }
      
      if ($mode == $this->mode_at_last_call){
         /* do nothing*/
      } else {
         wp_dequeue_style( $this->style_handle );
         wp_register_style( $this->style_handle, $this->get_style_uri4mode($mode)  );
         wp_enqueue_style( $this->style_handle );
         $this->mode_at_last_call = $mode;
      }
   }
}
?>