<?php
class M25_Menus
{   
   public function __construct(){
      add_filter( 'wp_nav_menu_items', array( $this, 'add_menuname_on_mode'), 10, 2 ); 
      add_filter( 'wp_page_menu', array( $this, 'add_menuname_for_page'), 10, 2 );
   } 
  
   /*
   * Add the name of the menu as first menu-item
   */
   function add_menuname_on_mode( $items, $args ){
      $single_quote = "'";
      $title = $this->get_menu_name( $args->theme_location );
      if ( false == $title ){
         $titel_item = '';
      } else {
      	 $titel_item = '<li id="menu-title" class="menu-title"><a href="javascript:m25ToggleMenuItems('.$single_quote.$args->container_id.$single_quote.')">'.$title.'</a></li>';
      	 
      }
      return $titel_item.$items;
   } 
   
   function add_menuname_for_page( $items, $args ){
   	  //das umschlieende conatiner-element entfernen:
   	  $items = strstr($items, "<li");
   	  $single_quote = "'";
   	  $title = esc_html__( 'Pages', 'wp-media-twentyfive' );
   	  $titel_item = '<li id="menu-title" class="menu-title"><a href="javascript:m25ToggleMenuItems('.$single_quote.$args['menu_id'].$single_quote.')">'.$title.'</a></li>';
   	  //die beiden letzten tags entfernen: </ul></div>
   	  $items = strstr($items, "</ul></div>", true);
   	  return $titel_item.$items;
   }
   
   function get_menu_name( $theme_location ) {
      if( ! $theme_location ) return false;
      $theme_locations = get_nav_menu_locations();
      if( ! isset( $theme_locations[$theme_location] ) ) return false;
      $menu_obj = get_term( $theme_locations[$theme_location], 'nav_menu' );
      if( ! $menu_obj ) $menu_obj = false;
      if( ! isset( $menu_obj->name ) ) return false;
      return $menu_obj->name;
   }

} 

//--- classes for changing the items of the menu ---

class M25_Menu_Walker extends Walker_Nav_Menu
{ 
   protected $last_ID;
   
   function start_lvl(&$output, $depth = 0, $args = Array()) {
      $indent = str_repeat("\t", $depth);
      $output .= $indent."\n".'<ul class="sub-menu m25-hide-menu" id="sub-menu-'.$this->last_ID.'">'."\n";
   }
   function end_lvl(&$output, $depth = 0, $args = Array()) {
      $indent = str_repeat("\t", $depth);
      $output .= $indent.'</ul>'."\n";
   }
   function start_el(&$output, $item, $depth = 0, $args = Array(), $id = 0){
      $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
      
      $class_names = $value = '';
      $classes = empty( $item->classes ) ? array() : (array) $item->classes;
   	  $classes[] = 'menu-item-' . $item->ID;
      
      /**
        * Filter the CSS class(es) applied to a menu item's <li>.
   	    *
   	    * @since 3.0.0
   	    *
   	    * @param array  $classes The CSS classes that are applied to the menu item's <li>.
   	    * @param object $item    The current menu item.
   	    * @param array  $args    An array of arguments. @see wp_nav_menu()
        */
   	  $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
   	  $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
   	  /**
	    * Filter the ID applied to a menu item's <li>.
	    *
	    * @since 3.0.1
	    *
	    * @param string The ID that is applied to the menu item's <li>.
	    * @param object $item The current menu item.
	    * @param array $args An array of arguments. @see wp_nav_menu()
	    */
	  $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
	  $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
      
	  $output .= $indent . '<li' . $id . $value . $class_names .'>';
      
      $atts = array();
      $atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
      $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
      $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
      $atts['href']   = ! empty( $item->url )        ? $item->url        : '';
      /** only the first level*/
      if ( 0 == $depth ) {
         $atts['onmouseover']   = 'javascript:m25ShowMenu('.$item->ID.')';
         $this->last_ID = $item->ID;
      }
      if ( 1 == $depth ) {
         $atts['onmouseout']   = 'javascript:m25HideMenu('.$this->last_ID.')';
         $atts['onmouseover']   = 'javascript:m25ShowMenu('.$this->last_ID.')';
      }
      /**
        * Filter the HTML attributes applied to a menu item's <a>.
        *
        * @since 3.6.0
        *
        * @param array $atts {
        *     The HTML attributes applied to the menu item's <a>, empty strings are ignored.
        *
        *     @type string $title  The title attribute.
        *     @type string $target The target attribute.
        *     @type string $rel    The rel attribute.
        *     @type string $href   The href attribute.
        * }
        * @param object $item The current menu item.
        * @param array  $args An array of arguments. @see wp_nav_menu()
        */
      $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );
      
      $attributes = '';
      foreach ( $atts as $attr => $value ) {
         if ( ! empty( $value ) ) {
            $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
	        $attributes .= ' ' . $attr . '="' . $value . '"';
         }
      }
      
      if ( ! ( empty( $args->before ) ) ) {
         $item_output = $args->before;
      } else {
      	 $item_output = '';
      }
      $item_output .= '<a'. $attributes .'>';
      /** This filter is documented in wp-includes/post-template.php */
      if ( ! ( empty( $args->link_before ) ) ) {
         $argsbefore = $args->link_before;
      } else {
      	 $argsbefore = '';
      }
      if ( ! ( empty( $args->link_after ) ) ) {
      	$argsafter = $args->link_after;
      } else {
      	$argsafter = '';
      }
      $item_output .= $argsbefore . apply_filters( 'the_title', $item->title, $item->ID ) . $argsafter;
      $item_output .= '</a>';
      if ( ! ( empty( $args->after ) ) ) {
         $item_output .= $args->after;
      }
      $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
   }
}

/* --- ---*/
   
   class M25_Page_Walker extends Walker_Page
   {
      protected $last_ID;
      
      function start_lvl(&$output, $depth = 0, $args = Array()) {
      	$indent = str_repeat("\t", $depth);
      	$output .= $indent."\n".'<ul class="sub-menu m25-hide-menu" id="sub-menu-'.$this->last_ID.'">'."\n";
      }
      function end_lvl(&$output, $depth = 0, $args = Array()) {
      	$indent = str_repeat("\t", $depth);
      	$output .= $indent.'</ul>'."\n";
      }
      
      /**
       * Outputs the beginning of the current element in the tree.
       *
       * @see Walker::start_el()
       * @since 2.1.0
       * @access public
       *
       * @param string  $output       Used to append additional content. Passed by reference.
       * @param WP_Post $page         Page data object.
       * @param int     $depth        Optional. Depth of page. Used for padding. Default 0.
       * @param array   $args         Optional. Array of arguments. Default empty array.
       * @param int     $current_page Optional. Page ID. Default 0.
       */
      public function start_el( &$output, $page, $depth = 0, $args = array(), $current_page = 0 ) {
      	if ( $depth ) {
      		$indent = str_repeat( "\t", $depth );
      	} else {
      		$indent = '';
      	}
      
      	$css_class = array( 'page_item', 'page-item-' . $page->ID, 'menu-item', 'menu-item-' . $page->ID  );
      
      	if ( isset( $args['pages_with_children'][ $page->ID ] ) ) {
      		$css_class[] = 'page_item_has_children';
      	}
      
      	if ( ! empty( $current_page ) ) {
      		$_current_page = get_post( $current_page );
      		if ( $_current_page && in_array( $page->ID, $_current_page->ancestors ) ) {
      			$css_class[] = 'current_page_ancestor';
      		}
      		if ( $page->ID == $current_page ) {
      			$css_class[] = 'current_page_item';
      		} elseif ( $_current_page && $page->ID == $_current_page->post_parent ) {
      			$css_class[] = 'current_page_parent';
      		}
      	} elseif ( $page->ID == get_option('page_for_posts') ) {
      		$css_class[] = 'current_page_parent';
      	}
      
      	/**
      	 * Filter the list of CSS classes to include with each page item in the list.
      	 *
      	 * @since 2.8.0
      	 *
      	 * @see wp_list_pages()
      	 *
      	 * @param array   $css_class    An array of CSS classes to be applied
      	 *                              to each list item.
      	 * @param WP_Post $page         Page data object.
      	 * @param int     $depth        Depth of page, used for padding.
      	 * @param array   $args         An array of arguments.
      	 * @param int     $current_page ID of the current page.
      	 */
      	$css_classes = implode( ' ', apply_filters( 'page_css_class', $css_class, $page, $depth, $args, $current_page ) );
      
      	if ( '' === $page->post_title ) {
      		/* translators: %d: ID of a post */
      	    $page->post_title = sprintf( __( '#%d (no title)', 'wp-media-twentyfive' ), $page->ID );
      	}
      
      	$args['link_before'] = empty( $args['link_before'] ) ? '' : $args['link_before'];
      	$args['link_after'] = empty( $args['link_after'] ) ? '' : $args['link_after'];
      	
      	/** adding attributes to the link-attribute */
      	/** only the first level */
      	$atts = array();
      	if ( 0 == $depth ) {
      		$atts['onmouseover']   = 'javascript:m25ShowMenu('.$page->ID.')';
      		$this->last_ID = $page->ID;
      	}
      	if ( 1 == $depth ) {
      		$atts['onmouseout']   = 'javascript:m25HideMenu('.$this->last_ID.')';
      		$atts['onmouseover']   = 'javascript:m25ShowMenu('.$this->last_ID.')';
      	}
      	
      	$attributes = '';
      	foreach ( $atts as $attr => $value ) {
      		if ( ! empty( $value ) ) {
      			$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
      			$attributes .= ' ' . $attr . '="' . $value . '"';
      		}
      	}
      	
      
      	$output .= $indent . sprintf(
      			'<li class="%s"><a href="%s"'.$attributes.'>%s%s%s</a>',
      			$css_classes,
      			get_permalink( $page->ID ),
      			$args['link_before'],
      			/** This filter is documented in wp-includes/post-template.php */
      			apply_filters( 'the_title', $page->post_title, $page->ID ),
      			$args['link_after']
      	);
      
      	if ( ! empty( $args['show_date'] ) ) {
      		if ( 'modified' == $args['show_date'] ) {
      			$time = $page->post_modified;
      		} else {
      			$time = $page->post_date;
      		}
      
      		$date_format = empty( $args['date_format'] ) ? '' : $args['date_format'];
      		$output .= " " . mysql2date( $date_format, $time );
      	}
      }
      
      /**
       * Outputs the end of the current element in the tree.
       *
       * @since 2.1.0
       * @access public
       *
       * @see Walker::end_el()
       *
       * @param string  $output Used to append additional content. Passed by reference.
       * @param WP_Post $page   Page data object. Not used.
       * @param int     $depth  Optional. Depth of page. Default 0 (unused).
       * @param array   $args   Optional. Array of arguments. Default empty array.
       */
      public function end_el( &$output, $page, $depth = 0, $args = array() ) {
      	$output .= "</li>\n";
      }
   }

?>