<?php
class M25_Content
{   
   protected $language_class;
   protected $prelabel = '<span class="m25-pagination-pre">%s</span>';
   protected $nextlabel = '<span class="m25-pagination-next">%s</span>';
   
   public function __construct( &$lang_class ){ 
      $this->language_class = $lang_class;
      add_action('pre_get_posts', array( $this, 'query_sticky_posts' ));
   } 
   
   /* use this in index.php, category and archive*/
   public function display_navlinks() {
      $pre = sprintf( $this->prelabel, '< '.esc_html__( 'previous page', 'wp-media-twentyfive' ) );
      $next = sprintf( $this->nextlabel, esc_html__( 'next page', 'wp-media-twentyfive' ).' >' );
      posts_nav_link( $sep ='', $pre,  $next);
   }
   
   /* use this in pages.php*/
   public function display_link_pages() {
      $pre = sprintf( $this->prelabel, '< '.esc_html__( 'previous page', 'wp-media-twentyfive' ) );
      $next = sprintf( $this->nextlabel, esc_html__( 'next page', 'wp-media-twentyfive' ).' >' );
      $args = array (
         'next_or_number'   => 'next',
         'before'           => '',
         'after'            => '',
         'link_before'      => '',
         'link_after'       => '',
         'nextpagelink'     => $next,
         'previouspagelink' => $pre,
      );
      wp_link_pages( $args );
   }
   
   /* use this in comments.php*/
   public function display_comments_page_link() {
   	$pre = sprintf( $this->prelabel, '< '.esc_html__( 'back', 'wp-media-twentyfive' ) );
   	$next = sprintf( $this->nextlabel, esc_html__( 'next', 'wp-media-twentyfive' ).' >' );
   	$args = array (
   			'prev_text'     => $next,
   			'next_text' => $pre,
   	);
   	paginate_comments_links( $args );
   }
   
   /* use this innstead of query_posts() -> for category.php, because the pagination can broke with query_posts()*/
   /* this function alters the main query */
   public function query_sticky_posts( $query ) {
      if ( !is_admin() ) {
   	     if ( $query->is_main_query() && ( $query->is_home() || $query->is_category() ) ){
   	        //filter sticky posts out, because they where treated separately
   	        $sticky = get_option( 'sticky_posts' );
   	        $query->set('ignore_sticky_posts', 1 );
   	        $query->set('post__not_in', $sticky );
   	     }
      }
   } //function 
} //class
?>