<?php
global $m25_widgets;
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
   <meta charset="<?php bloginfo( 'charset' ); ?>" />
   <link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>" type="text/css" media="screen" />
   <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
   <?php wp_head(); ?> 
</head>

<body <?php body_class(); ?>>
<div class="header">
   <div class="content-area">
      <?php
      $menu = array(
	     'theme_location'  => 'media25-header',
	     'container'       => 'div',
	     'container_class' => 'header-menu',
	     'container_id'    => 'header-menu',
	     'echo'            => true,
	     'fallback_cb'     => 'm25_nav_menu_fallback',
	     'depth'           => 2,
	     'walker'          => new M25_Menu_Walker()
      );

      wp_nav_menu( $menu ); 
      get_search_form();?>
   </div> <!-- content-area -->
</div> <!-- header -->

<div class="m25-top">
   <div class="content-area">
      <?php $m25_widgets->display_widget_area( 'top' ); ?>
   </div> <!-- content-area -->
</div> <!-- m25-top -->
