<?php
/**
 * media25 functions and definitions.
 *
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development and
 * http://codex.wordpress.org/Child_Themes), you can override certain functions
 * (those wrapped in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before the parent
 * theme's file, so the child theme functions would be used.
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are instead attached
 * to a filter or action hook.
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Media25
 */


/* ---------- INIT -------------- */
require( dirname( __FILE__ ) . '/inc/class-m25-internationalization.php' );
$m25_lang = new M25_Internationalization();

require( dirname( __FILE__ ) . '/inc/class-m25-screen-switcher.php' );
require( dirname( __FILE__ ) . '/inc/class-m25-widgets.php' );
require( dirname( __FILE__ ) . '/inc/class-m25-menus.php' );
require( dirname( __FILE__ ) . '/inc/class-m25-content.php' );
  
add_action('init', 'm25_make_menus');
add_action('init', 'm25_theme_support');
add_action('get_header', 'm25_enable_threaded_comments');
add_action('wp_enqueue_scripts', 'm25_load_scripts' );
add_action('wp_enqueue_scripts', 'm25_load_styles' );
add_filter('query_vars', 'm25_parameter_queryvars' );

function m25_parameter_queryvars( $qvars ){
   $qvars[] = 'm25Comment';
   return $qvars;
}

$m25_widgets = new M25_Widgets( $m25_lang );
$m25_content = new M25_Content( $m25_lang );
$m25_menus = new M25_Menus();
$m25_sw = new M25_Screen_Switcher();
 

/* ---------- Skripts ------------- */
function m25_load_scripts(){
   wp_enqueue_script('jquery');
   wp_register_script('jquery-cookie',get_template_directory_uri().'/js/jquery.cookie.js',array( 'jquery' ));
   wp_enqueue_script('jquery-cookie');
   wp_register_script('m25_screenswitcher',get_template_directory_uri().'/js/m25.screenswitcher.js');
   wp_enqueue_script('m25_screenswitcher');
   wp_register_script( 'm25_menus', get_template_directory_uri().'/js/m25.menus.js' );
   wp_enqueue_script( 'm25_menus' );
}

function m25_enable_threaded_comments(){
   if ( !is_admin() ) {
      if ( is_singular() && comments_open() && ( get_option( 'thread_comments' ) == 1 ) ){
         wp_enqueue_script( 'comment-reply' );
      }
   }
}

/* ---------- Styles  ------------- */
function m25_load_styles(){
   wp_enqueue_style( 'm25_google_font', 'https://fonts.googleapis.com/css?family=Open+Sans:400,400italic,700|Arimo:400,400italic,700&subset=latin,latin-ext' );
   wp_register_style( 'media25_style', get_template_directory_uri() . '/style.css' );
}

/* ---------- MENU und Theme-Einstellungen ------------- */
function m25_make_menus(){
   global $m25_lang;
   // This theme uses wp_nav_menu() in one location.
   register_nav_menu( 'media25-header', esc_html__( 'Main menu','wp-media-twentyfive') );
   register_nav_menu( 'media25-menu-footer-a', esc_html__( 'Footer menu A','wp-media-twentyfive') );
   register_nav_menu( 'media25-menu-footer-b', esc_html__( 'Footer menu B','wp-media-twentyfive') );
   register_nav_menu( 'media25-menu-footer-c', esc_html__( 'Footer menu C','wp-media-twentyfive') );
}

function m25_theme_support(){
   global $wp_version, $content_width, $m25_sw;

   add_theme_support( 'custom-background', array(
      'default-color' => '#7BA9DB'
   ) );

   add_theme_support( 'post-thumbnails' );
   
   add_theme_support( 'automatic-feed-links' ); 
   
   if ( ! isset( $content_width ) ) {
      $content_width = $m25_sw->get_actual_width();
   }
   
   add_theme_support( 'title-tag' );
}

/*--- adapted fallback function for wp_nav_menu ---*/
function m25_nav_menu_fallback( $args = array() ){
	$args_page = array(
			'sort_column' => 'menu_order, post_title',
			'menu_class'  => 'header-menu',
			'menu_id'     => 'header-menu',
			'container'   => 'div',
			'echo'        => true,
			'show_home'   => false,
			'link_before' => '',
			'link_after'  => '',
			'before'      => '<ul class="menu">',
			'after'       => '</ul>',
			'walker'       => new M25_Page_Walker()
	 );

	echo '<div id="header-menu" class="header-menu"><ul id="menu-hauptmenu" class="menu">';
	wp_page_menu ( $args_page );
	echo '</ul></div>';
}