<?php 
global $m25_lang;
global $post_id; 

if ( post_password_required() ) {
	echo '<p class="nocomments">';
	esc_html_e( 'This post is password protected. Enter the password to view comments.', 'wp-media-twentyfive' );
	echo '</p>';
	return;
}

$post = get_post( $post_id );

if ( have_comments() ) { //have_comments only works after calling comments_template!  ?>
   <div class="m25-comment-area">
      <h4 id="comments">
         <?php $comments_num = get_comments( array( 'status' => 'approve', 'count' => 1, 'post_id' => $post_id ) ); ?>
         <?php printf( _n( 'One comment', '%s comments', $comments_num, 'wp-media-twentyfive' ), number_format_i18n( $comments_num ) ); ?>
      </h4>

      <ul class="commentlist">
         <?php wp_list_comments(); ?>
      </ul>
      <div class="navigation">
         <div class="alignleft"><?php previous_comments_link() ?></div>
         <div class="alignright"><?php next_comments_link() ?></div>
      </div>   
      <?php comment_form(); ?>
   </div>
<?php } else { // this is displayed if there are no comments so far ?>
   <?php if ( comments_open() ) { ?>
      <div class="m25-comment-area">
         <h4 id="comments">
            <?php esc_html_e( 'Until now no comments', 'wp-media-twentyfive'); ?>
         </h4>
         <?php comment_form(); ?>
      </div>
   <?php } else { // comments are closed 
      if ( 'page' == $post->post_type ) {
         //for static pages there should be no message if comments are disabled based on the instrutions from unit test data
      } else { ?>
         <div class="m25-comment-area">
            <h4 id="comments">
               <?php esc_html_e( 'commenting closed', 'wp-media-twentyfive'); ?>
            </h4>
         </div>
      <?php }; 
   };
};
?>    

