<?php
/**
 * WP Invictus Theme Customizer
 *
 * @package WP Invictus
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wp_invictus_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
}
add_action( 'customize_register', 'wp_invictus_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function wp_invictus_customize_preview_js() {
	wp_enqueue_script( 'wp_invictus_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'wp_invictus_customize_preview_js' );




if ( ! function_exists( 'wp_invictus_theme_customizer' ) ) :
	function wp_invictus_theme_customizer( $wp_customize ) {
		
		$wp_customize->remove_section( 'title_tagline');		
		/* logo option */
		$wp_customize->add_section( 'wp_invictus_logo_section' , array(
			'title'       => __( 'Site Logo', 'wp-invictus' ),
			'priority'    => 20,
			'description' => __( 'Upload a logo to replace the default site name in the header', 'wp-invictus' ),
		) );
		
		$wp_customize->add_setting( 'wp_invictus_logo', array (
			'sanitize_callback' => 'esc_url_raw',
		) );
		
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wp_invictus_logo', array(
			'label'    => __( 'Choose your logo (ideal width is 100-300px and ideal height is 40-100px)', 'wp-invictus' ),
			'section'  => 'wp_invictus_logo_section',
			'settings' => 'wp_invictus_logo',
		) ) );		
		
		
		
		/*****************************************************************************************************************/
		/* Home Feature */
		class WP_Customize_Textarea_Control extends WP_Customize_Control {
			public $type = 'textarea';
		 
			public function render_content() {
				?>
					<label>
						<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
						<textarea rows="5" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
					</label>
				<?php
			}
		}
		function wp_invictus_sanitize_textarea( $text ) {
			return esc_textarea( $text );
		}
		
		function wp_invictus_sanitize_text_field( $str ) {
			return sanitize_text_field( $str );
		}
		
		if ( ! function_exists( 'wp_invictus_sanitize_checkbox' ) ) :
			function wp_invictus_sanitize_checkbox( $input ) {
				if ( $input == 1 ) {
					return 1;
				} else {
					return 0;
				}
			}
		endif;
		
		
		$wp_customize->add_section( 'wp_invictus_home_featured_section' , array(
			'title'       => __( 'Home Feature', 'wp-invictus' ),
			'priority'    => 21,
			'description' => __( 'Home Main Feature', 'wp-invictus' ),
		));	
		$wp_customize->add_setting( 'wp_invictus_feature_display', array (
			'default'        => 0,
			'sanitize_callback' => 'wp_invictus_sanitize_checkbox',
		) );
		
		 $wp_customize->add_control('wp_invictus_feature_display', array(
			'settings' => 'wp_invictus_feature_display',
			'label' => __('Show the Home Main Feature', 'wp-invictus'),
			'section' => 'wp_invictus_home_featured_section',
			'type' => 'checkbox',
		));	
		
		$wp_customize->add_setting( 'wp_invictus_home_featured_image', array (
			'sanitize_callback' => 'esc_url_raw',
		));
		
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'wp_invictus_home_featured_image', array(
               'label'      => __( 'Upload a home feature image', 'wp-invictus' ),
               'section'    => 'wp_invictus_home_featured_section',
               'settings'   => 'wp_invictus_home_featured_image'
			   )
		));
		
		$wp_customize->add_setting( 'wp_invictus_home_featured_title', array (
			'default' => '',
			'sanitize_callback' => 'wp_invictus_sanitize_text_field'
		));
		
		$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'wp_invictus_home_featured_title', array(
               'label'      => __( 'Enter feature title', 'wp-invictus' ),
               'section'    => 'wp_invictus_home_featured_section',
               'settings'   => 'wp_invictus_home_featured_title',
			   'type'   	=> 	'text',
			   'priority'    => 80
			   )
		));
		
		$wp_customize->add_setting( 'wp_invictus_home_featured_description', array (
			'default' => '',
			'sanitize_callback' => 'wp_invictus_sanitize_textarea'
			
		));
		
		$wp_customize->add_control(new WP_Customize_Textarea_Control($wp_customize, 'wp_invictus_home_featured_description', array(
               'label'      => __( 'Enter feature description', 'wp-invictus' ),
               'section'    => 'wp_invictus_home_featured_section',
               'settings'   => 'wp_invictus_home_featured_description',
			   'priority'    => 81
			   )
		));
		
		$wp_customize->add_setting( 'wp_invictus_home_featured_button', array (
			'default' => '',
			'sanitize_callback' => 'wp_invictus_sanitize_text_field'
			
		));
		
		$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'wp_invictus_home_featured_button', array(
               'label'      => __( 'Enter feature button caption', 'wp-invictus' ),
               'section'    => 'wp_invictus_home_featured_section',
               'settings'   => 'wp_invictus_home_featured_button',
			   'type'   	=> 	'text',
			   'priority'    => 82
			   )
		));
		
		$wp_customize->add_setting( 'wp_invictus_home_featured_url', array (
			'sanitize_callback' => 'esc_url_raw',
		));
		
		$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'wp_invictus_home_featured_url', array(
               'label'      => __( 'Enter feature button target URL', 'wp-invictus' ),
               'section'    => 'wp_invictus_home_featured_section',
               'settings'   => 'wp_invictus_home_featured_url',
			   'priority'    => 83
			   )
		));
		
		// author bio in posts option 
		$wp_customize->add_section( 'wp_invictus_author_bio_section' , array(
			'title'       => __( 'Display Author Bio', 'wp-invictus' ),
			'priority'    => 31,
			'description' => __( 'Option to show/hide the author bio in the posts.', 'wp-invictus' ),
		) );
		
		$wp_customize->add_setting( 'wp_invictus_author_bio', array (
			'default'        => 0,
			'sanitize_callback' => 'wp_invictus_sanitize_checkbox',
		) );
		
		 $wp_customize->add_control('wp_invictus_author_bio', array(
			'settings' => 'wp_invictus_author_bio',
			'label' => __('Show the author bio in posts?', 'wp-invictus'),
			'section' => 'wp_invictus_author_bio_section',
			'type' => 'checkbox',
		));
		
		/* social media option */
		$wp_customize->add_section( 'wp_invictus_social_section' , array(
			'title'       => __( 'Social Media Icons', 'wp-invictus' ),
			'priority'    => 32,
			'description' => __( 'Optional social media buttons in the header', 'wp-invictus' ),
		) );
		
		$wp_customize->add_setting( 'wp_invictus_facebook', array (
			'sanitize_callback' => 'esc_url_raw',
		) );
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wp_invictus_facebook', array(
			'label'    => __( 'Enter your Facebook url', 'wp-invictus' ),
			'section'  => 'wp_invictus_social_section',
			'settings' => 'wp_invictus_facebook',
			'priority'    => 101,
		) ) );
	
		$wp_customize->add_setting( 'wp_invictus_twitter', array (
			'sanitize_callback' => 'esc_url_raw',
		) );
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wp_invictus_twitter', array(
			'label'    => __( 'Enter your Twitter url', 'wp-invictus' ),
			'section'  => 'wp_invictus_social_section',
			'settings' => 'wp_invictus_twitter',
			'priority'    => 102,
		) ) );
		
		$wp_customize->add_setting( 'wp_invictus_youtube', array (
			'sanitize_callback' => 'esc_url_raw',
		) );
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wp_invictus_youtube', array(
			'label'    => __( 'Enter your Youtube url', 'wp-invictus' ),
			'section'  => 'wp_invictus_social_section',
			'settings' => 'wp_invictus_youtube',
			'priority'    => 106,
		) ) );
		
		$wp_customize->add_setting( 'wp_invictus_email', array (			
			'sanitize_callback' => 'sanitize_email',
		) );
		
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wp_invictus_email', array(
			'label'    => __( 'Enter your email address', 'wp-invictus' ),
			'section'  => 'wp_invictus_social_section',
			'settings' => 'wp_invictus_email',
			'priority'    => 112,
		) ) );
		
		/* color theme */
		$wp_customize->add_setting( 'wp_invictus_primary_theme_color', array (
			'default' => '#00cc77',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wp_invictus_primary_theme_color', array(
			'label'    => __( 'Primary Theme Color Option', 'wp-invictus' ),
			'section'  => 'colors',
			'settings' => 'wp_invictus_primary_theme_color',
			'priority' => 21,
		) ) );
		
				
	}
endif;
add_action('customize_register', 'wp_invictus_theme_customizer');


/**
* Apply Color Scheme
*/
if (!function_exists( 'wp_invictus_apply_color' ) ) :
  function wp_invictus_apply_color() {
	?>
	<style id="color-settings">
	<?php if ( get_theme_mod('wp_invictus_primary_theme_color') ) : ?>
	a, .btn-default:hover, h1.feature-title, .main-navigation li:hover > a, h3.entry-title a:hover, .theme-name a:hover, .theme-name h3:hover, .action-button, .post_box a.meta-comment:hover, .entry-meta span.comments-link a:hover, aside ul li a:hover, footer ul li a:hover, footer .meta-info span, footer .meta-info a, span.post-date, ul li.recentcomments, .entry-meta span.posted-on, .main-navigation .current_page_item > a, .main-navigation .current-menu-item > a, .main-navigation .current_page_ancestor > a, .main-navigation ul ul.children >li > a:hover, .main-navigation ul ul.sub-menu >li > a:hover, .entry-content ol li:before, .entry-content ul li:before, a.comment-reply-link {
		color:<?php echo get_theme_mod('wp_invictus_primary_theme_color'); ?>;
		}	
		.btn-default, .pagination .fa, footer .widget_calendar thead tr, .navbar-toggle .icon-bar, #respond #submit, .post-content form input[type=submit], .post-content form input[type=button], .nav_container, #sidebar .widget-title, .tagcloud a {background:<?php echo get_theme_mod('wp_invictus_primary_theme_color'); ?>;}
			
	<?php endif; ?>
	
	
	</style>
	<?php	  

  }
endif;
add_action( 'wp_head', 'wp_invictus_apply_color' );