<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package WP Invictus
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'wp-invictus' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
    	<div class="header-container">
            <div class="container">
            	<div class="row">
					<div class="col-md-12">
                		<div class="site-branding">
                            <?php if ( get_theme_mod( 'wp_invictus_logo' ) ) : ?>
                            <div id="site-logo">
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
                                    <img src="<?php echo esc_url( get_theme_mod( 'wp_invictus_logo' ) ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" />
                                </a>
                            </div>
                            <?php else : ?>
                                <div id="site-logo">
                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name', 'wp-invictus' ); ?></a></h1>
                                    <h2 class="site-description"><?php bloginfo( 'description', 'wp-invictus' ); ?></h2>
                                </div>
                            <?php endif; ?>
                            
                        </div><!-- .site-branding -->
                        <?php dynamic_sidebar('top-right-widget'); ?>
                        <div class="clearfix"></div>
                    </div>
                </div>
        	</div>
        </div>
        <div class="nav_container">
        	<div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <nav id="site-navigation" class="main-navigation container-fluid" role="navigation">
                              <button class="menu-toggle navbar-toggle" data-toggle="collapse" data-target="#navbar-collapse">
                                <span class="sr-only"><?php _e( 'Toggle navigation', 'wp-invictus' ); ?></span>            
                                <span class="icon-bar"></span>            
                                <span class="icon-bar"></span>            
                                <span class="icon-bar"></span>
                              </button>
                            <div class="collapse navbar-collapse" id="navbar-collapse">  
                                <?php wp_nav_menu( array( 'theme_location' => 'primary', 'fallback_cb' => 'wp_invictus_menu' ) ); ?>
                            </div>
                        </nav>
                    </div> 
                </div>       
			</div>                    
        </div> <!--end nav_container-->
                
        <?php if((is_front_page() || is_home()) && get_theme_mod('wp_invictus_feature_display')){ ?>
       <div class="slider-container">
            <div class="container">
            	<div id="home-feature" class="row">
            		<div class="col-lg-6 col-lg-push-6">
                    	<?php if ( get_theme_mod( 'wp_invictus_home_featured_image' ) ) { ?>
                    	<img src="<?php echo esc_url(get_theme_mod( 'wp_invictus_home_featured_image' )); ?>" alt="" class="aligncenter" />
                        <?php } else { ?>
                        		<div class="img_feature_frame"><h1 class="default_title"><?php _e('Set Home Page<br /> Feature Image' ,'wp-invictus'); ?></h1></div>
                        <?php } ?>
                    </div>
            	
                	<div id="feature-details" class="col-lg-6 col-lg-pull-6">
                    	<?php if ( get_theme_mod( 'wp_invictus_home_featured_title' ) ) { ?>
                    		<h1 class="feature-title"><?php echo get_theme_mod( 'wp_invictus_home_featured_title' ); ?></h1>
                        <?php }else { ?>
                    		<h1 class="feature-title"><?php _e('Feature Title' ,'wp-invictus'); ?></h1>
                        <?php }?>
                        <?php if ( get_theme_mod('wp_invictus_home_featured_description' ) ) { ?>
                    		<p class="feature-description"><?php echo get_theme_mod( 'wp_invictus_home_featured_description' ); ?></p>
                        <?php }else { ?>
                    		 <p class="feature-description"><?php _e('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled' ,'wp-invictus'); ?></p>
                        <?php }?>
                       	
                         <?php if ( get_theme_mod('wp_invictus_home_featured_button' ) ) { ?>
                            <center><a class="btn btn-default feature-btn" href="<?php if ( get_theme_mod( 'wp_invictus_home_featured_url' ) )  echo esc_url(get_theme_mod( 'wp_invictus_home_featured_url' ));?>" role="button"><?php echo get_theme_mod( 'wp_invictus_home_featured_button' ); ?></a></center>
                        <?php }else { ?>
                    		 <center><a class="btn btn-default feature-btn" href="<?php if ( get_theme_mod( 'wp_invictus_home_featured_url' ) )  echo esc_url(get_theme_mod( 'wp_invictus_home_featured_url' ));?>" role="button"><?php _e('Read More' ,'wp-invictus'); ?></a></center>
                        <?php }?>
                        
                    </div>
                    
                </div>
            </div>
        </div><!-- .slider-container-->
        <?php } ?>
    </header><!-- #masthead -->
    

	<div id="content" class="site-content container">
