<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package WP Invictus
 */
?>

	</div><!-- #content -->	
	<footer id="colophon" class="site-footer" role="contentinfo">
    	<div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <?php dynamic_sidebar('footer-one'); ?>
                    </div>
                    <div class="col-md-3">
                        <?php dynamic_sidebar('footer-two'); ?>
                    </div>
                    <div class="col-md-3">
                        <?php dynamic_sidebar('footer-three'); ?>
                    </div>
                    <div class="col-md-3">
                        <?php dynamic_sidebar('footer-four'); ?>
                    </div>
                </div>
        </div>
        <div class="site-info">
            <div class="container">
                <div class="row">
					<div class="footer-social-media col-sm-6 col-lg-push-6">
                        <?php if ( get_theme_mod( 'wp_invictus_email' ) ) : ?>
                            <a href="<?php _e('mailto:', 'wp-invictus'); echo sanitize_email( get_theme_mod( 'wp_invictus_email' ) ); ?>" title="<?php esc_attr_e('Email' ,'wp-invictus'); ?>"><span class="fa fa-envelope"></span><br /><?php _e('Contact Us' ,'wp-invictus'); ?></a>
                        <?php endif; ?>             	
                        <?php if ( get_theme_mod( 'wp_invictus_youtube' ) ) : ?>
                            <a href="<?php echo esc_url( get_theme_mod( 'wp_invictus_youtube' ) ); ?>" title="<?php esc_attr_e('You Tube' ,'wp-invictus'); ?>"><span class="fa fa-youtube"></span><br /><?php _e('You Tube' ,'wp-invictus'); ?></a>
                        <?php endif; ?>
                        <?php if ( get_theme_mod( 'wp_invictus_twitter' ) ) : ?>
                            <a href="<?php echo esc_url( get_theme_mod( 'wp_invictus_twitter' ) ); ?>" title="<?php esc_attr_e('Twitter' ,'wp-invictus'); ?>"><span class="fa fa-twitter"></span><br /><?php _e('Twitter' ,'wp-invictus'); ?></a>
                        <?php endif; ?>
                        <?php if ( get_theme_mod( 'wp_invictus_facebook' ) ) : ?>
                            <a href="<?php echo esc_url( get_theme_mod( 'wp_invictus_facebook' ) ); ?>" title="<?php esc_attr_e('Facebook' ,'wp-invictus'); ?>"><span class="fa fa-facebook"></span><br /><?php _e('Facebook' ,'wp-invictus'); ?></a>
                        <?php endif; ?>
                    </div>
                    <div class="copy-right col-sm-6 col-lg-pull-6">
                        <?php echo __('&copy; ', 'wp-invictus') . esc_attr( get_bloginfo( 'name', 'display' ) );  ?>
                        <?php if(is_home() && !is_paged()){?>            
                            <?php _e('- Powered by ', 'wp-invictus'); ?><a href="<?php echo esc_url( __( 'http://wordpress.org/', 'wp-invictus' ) ); ?>" title="<?php esc_attr_e( '' ); ?>"><?php _e('WordPress' ,'wp-invictus'); ?></a>
            				<?php _e(' and ', 'wp-invictus'); ?><a href="<?php echo esc_url( __( 'http://invictusthemes.com/', 'wp-invictus' ) ); ?>"><?php _e('Invictus Themes', 'wp-invictus'); ?></a>
                        <?php } ?>
                	</div>
                </div>
            </div>
        </div><!-- .site-info -->
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
