<?php
/**
 * @package WP Invictus
 */
?>
<div class="item col-md-6">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    	<div class="post_box">
            <header class="entry-header">
                <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>        
                <?php if ( 'post' == get_post_type() ) : ?>
                <div class="entry-meta row">
                    <?php wp_invictus_posted_on(); ?>
                </div><!-- .entry-meta -->
                <?php endif; ?>
            </header><!-- .entry-header -->
        	<a href="<?php esc_url(the_permalink('')) ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('wp-invictus-post-thumb'); ?></a>
            <div class="entry-content">
                <?php
                    /* translators: %s: Name of current post */
                    the_excerpt();
					
                ?>
        		
                <?php
                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . __( 'Pages:', 'wp-invictus' ),
                        'after'  => '</div>',
                    ) );
                ?>
            </div><!-- .entry-content -->
            <a href="<?php the_permalink('') ?>" class="read_more"><?php _e( 'Read More >>', 'wp-invictus' ); ?></a>
        </div>
    </article><!-- #post-## -->
    <div class="clearfix"></div>
</div>
