<?php
/**
 * Template Name: Blog Template
 * Description: A full-width template with no sidebar
 */
 ?>
<?php get_header(); ?>
<div class="row">
    <div class="clearfix"></div>
    <div class="margin-bottom-separator"></div> 
	<div id="primary" class="content-area col-md-9" >      
        <main id="main" class="site-main row" role="main">
            <div id="manson">
            <?php
				if ( get_query_var('paged') ) {
                        $paged = get_query_var('paged');
                } elseif ( get_query_var('page') ) {
                        $paged = get_query_var('page');
                } else {
                        $paged = 1;
                }
				
				$temp = $wp_query;
 				$wp_query = null;
				$wp_query = new WP_Query();
				$wp_query->query( array(
					'post_type' => 'post',
					'paged' => $paged
				));
			?>
            <?php if ( $wp_query->have_posts() ) : ?>
    
                <?php /* Start the Loop */ ?>
                <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
    
                    <?php
                        /* Include the Post-Format-specific template for the content.
                         * If you want to override this in a child theme, then include a file
                         * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                         */
                        get_template_part( 'content', get_post_format() );
						wp_reset_postdata();
                    ?>
                    
                <?php endwhile; ?>
                
            <?php else : ?>
    
                <?php get_template_part( 'content', 'none' ); ?>
    
            <?php endif; ?>
            <?php if (function_exists("wp_invictus_pagination")) {
                            wp_invictus_pagination();							
                        }
                ?>
                <div class="clearfix"></div>
            </div>
        </main><!-- #main -->
        <div class="clearfix"></div>
    </div><!-- #primary -->

    <aside id="widget" class="widget-container col-md-3 ">
        <?php get_sidebar(); ?>
    </aside>
</div>
<?php get_footer(); ?>