<?php
/**
 * Invictus functions and definitions
 *
 * @package Invictus
 */
require get_template_directory() . '/inc/pagination.php';
require get_template_directory() . '/inc/widget.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/**
 * Set the content width based on the theme's design and stylesheet.
 */
 
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'wp_invictus_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function wp_invictus_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 */
	load_theme_textdomain( 'wp-invictus', get_template_directory() . '/languages' );
	// Add default posts and comments RSS feed links to head.
	add_theme_support( "title-tag" );
	add_theme_support( 'automatic-feed-links' );
	add_editor_style();
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'wp-invictus-widget-post-thumb',  70, 70, true );
	add_image_size( 'wp-invictus-post-thumb',  600 );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'wp-invictus' )
	) );
	

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'wp_invictus_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif; // wp_invictus_setup
add_action( 'after_setup_theme', 'wp_invictus_setup' );


if ( !function_exists( 'wp_invictus_menu' ) ){
	function wp_invictus_menu() {	
		require get_template_directory() . '/inc/wp-invictus-menu.php';	
	}
}
/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function wp_invictus_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'wp-invictus' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="widget-title"><h1>',
		'after_title'   => '</h1></div>',
	) );
	register_sidebar( array(
		'name' => __( 'Banner Widget', 'wp-invictus' ),
		'description' => 'Enter your banner code into this text widget.',
		'id' => 'top-right-widget',
		'before_widget' => '<div id="top-widget">',
		'after_widget' => "</div>",
		'before_title' => '',
		'after_title' => '',
	) );
	register_sidebar( array(
		'name' => __( 'Footer One', 'wp-invictus' ),
		'id' => 'footer-one',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<div class="widget-title"><h2>',
		'after_title' => '</h2><div class="arrow-right"></div></div>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Two', 'wp-invictus' ),
		'id' => 'footer-two',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<div class="widget-title"><h2>',
		'after_title' => '</h2><div class="arrow-right"></div></div>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Three', 'wp-invictus' ),
		'id' => 'footer-three',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<div class="widget-title"><h2>',
		'after_title' => '</h2><div class="arrow-right"></div></div>',
	) );
	
		register_sidebar( array(
		'name' => __( 'Footer Four', 'wp-invictus' ),
		'id' => 'footer-four',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<div class="widget-title"><h2>',
		'after_title' => '</h2><div class="arrow-right"></div></div>',
	) );
	
		
}
add_action( 'widgets_init', 'wp_invictus_widgets_init' );

/**
 * Enqueue scripts and styles.
 */

function wp_invictus_scripts() {
	global $wp_scripts;
	global $wp_styles;
	
	wp_enqueue_style( 'wp-invictus-responsive', get_template_directory_uri() .'/css/bootstrap.css', array(), false ,'screen' );
	wp_enqueue_style( 'wp-invictus-font_awesome', get_template_directory_uri() .'/assets/css/font-awesome.min.css' );
	wp_enqueue_style('wp-invictus-googleFonts', '//fonts.googleapis.com/css?family=Open+Sans|Oswald');
	wp_enqueue_style( 'wp-invictus-ie', get_stylesheet_directory_uri() . "/css/ie.css", array()  );
    $wp_styles->add_data( 'wp-invictus-ie', 'conditional', 'IE' );
	wp_enqueue_style( 'wp-invictus-style', get_stylesheet_uri() );
	
	wp_enqueue_script( 'wp-invictus-responsive_js', get_template_directory_uri() . '/js/bootstrap.js', array('jquery') );
	wp_enqueue_script( 'wp-invictus-navigation_js', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true  );
	wp_enqueue_script( 'wp-invictus-load_images_js', get_template_directory_uri() . '/js/jquery.imagesloaded.js');
	wp_enqueue_script( 'wp-invictus-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );
	wp_enqueue_script( 'wp-invictus-ie', get_template_directory_uri() . "/js/html5shiv.js");
	$wp_scripts->add_data( 'wp-invictus-ie', 'conditional', 'lt IE 9' );
	wp_enqueue_script( 'wp-invictus-ie-responsive', get_template_directory_uri() . "/js/ie-responsive.js");
	$wp_scripts->add_data( 'wp-invictus-ie-responsive', 'conditional', 'lt IE 9' );
	
	
	wp_register_script( "wp-invictus-custom_js", get_template_directory_uri() . "/js/custom.js", array('jquery-masonry') );
	wp_enqueue_script( "wp-invictus-custom_js" );
		

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'wp_invictus_scripts' );

function wp_invictus_excerpt_length( $length ) {
	return 70;
}
add_filter( 'excerpt_length', 'wp_invictus_excerpt_length', 999 );

function wp_invictus_excerpt_more( $more ) {
	return '...';
}
add_filter('excerpt_more', 'wp_invictus_excerpt_more');


/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';


/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
