<?php
/**
 * WP Inspire Writer functions and definitions
 *
 * @package WP Inspire Writer
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
}

if ( ! function_exists( 'wp_inspire_writer_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function wp_inspire_writer_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on WP Inspire Writer, use a find and replace
	 * to change 'wp-inspire-writer' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'wp-inspire-writer', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
		add_theme_support( 'post-thumbnails' );
		add_image_size('large-thumb', 1060, 650, true);
		add_image_size('index-thumb', 780, 250, true);
	
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'wp-inspire-writer' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link',
	) );

	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'wp_inspire_writer_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif; // wp_inspire_writer_setup
add_action( 'after_setup_theme', 'wp_inspire_writer_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function wp_inspire_writer_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'wp-inspire-writer' ),
		'id'            => 'sidebar-1',
		'description'   => 'Widgets placed here will appear in the Sidebar area',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
	
		register_sidebar( array(
		'name'          => __( 'Footer Sidebar', 'wp-inspire-writer' ),
		'id'            => 'sidebar-2',
		'description'   => 'Widgets placed here will appear in the footer area',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}
add_action( 'widgets_init', 'wp_inspire_writer_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function wp_inspire_writer_scripts() {
	wp_enqueue_style( 'wp-inspire-writer-style', get_stylesheet_uri() );
	
	// Google Fonts
	wp_enqueue_style( 'wp-inspire-writer-google-fonts', '//fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,300,600,700,800');
	
	// FontAwesome
	wp_enqueue_style('wp-inspire-writer_fontawesome',  get_template_directory_uri() . '/fonts/font-awesome/css/font-awesome.min.css');
	
	// Global Right Sidebar         
	wp_enqueue_style( 'wp-inspire-writer-layout-style' , get_template_directory_uri() . '/layouts/content-sidebar.css');

	wp_enqueue_script( 'wp-inspire-writer-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

	wp_enqueue_script( 'wp-inspire-writer-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'wp_inspire_writer_scripts' );

/**
 * Implement the Custom Header feature.
* require get_template_directory() . '/inc/custom-header.php';
 */ 

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
