<?php
/**
 * @package WP Inspire Writer
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post-box">
	<header class="entry-header">

		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php wp_inspire_writer_posted_on(); ?>
		</div><!-- .entry-meta -->


		<?php endif; ?>
	</header><!-- .entry-header -->

	<?php
		if (has_post_thumbnail()) {
			echo '<div class="small-index-thumbnail clear">';
			echo '<a href="' . esc_url( get_permalink() ) . '" title="' . __('Read ', 'wp_inspire_writer') . esc_attr( get_the_title()) . '" rel="bookmark">';
			the_post_thumbnail('index-thumb');
			echo '</a>';
			echo '</div>';
		}
	?>
<div class="entry-content">
    <?php the_excerpt(); ?>
</div><!-- .entry-content -->

	<footer class="entry-footer continue-reading">
		<?php wp_inspire_writer_entry_footer(); ?>
		</br>		<div class="continue-reading-button">
		<?php echo '<a href="' . esc_url( get_permalink() ) . '" title="' . __('Continue Reading ', 'wp_inspire_writer') . esc_attr( get_the_title() ) . '" rel="bookmark">' . __('Continue Reading ', 'wp_inspire_writer') . '</a>'; ?>				
		</div>
		<!-- continue-reading-button -->
	<?php
		// Display a thumb tack in the top right hand corner if this post is sticky
		if (is_sticky()) {
			echo '<i class="fa fa-star fa-2x"></i>';
		}
	?>
	</footer><!-- .entry-footer -->
	</div><!-- .post-box -->
</article><!-- #post-## -->
