<?php
/**
 * @package WP Inspire Writer
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		<div class="entry-meta">
			<?php wp_inspire_writer_posted_on(); ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->
			<?php 
				if (has_post_thumbnail()) {
					echo '<div class="single-post-thumbnail clear">';
					echo '<div class="image-shifter">';
					the_post_thumbnail('large-thumb');
					echo '</div>';
					echo '</div>';
				}
			?>

	<div class="entry-content">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'wp-inspire-writer' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php wp_inspire_writer_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
