<?php 
/**
 *
 * @package markito-x
 * 
 * @since 1.0.4
 * 
*/
if ( ! class_exists( 'wp_digest_Theme_Back_To_Top_Section_Customizer' ) ) :

/**
   * Settings for customizer Back To Top Section 
**/
class wp_digest_Theme_Back_To_Top_Section_Customizer {

    public function __construct() {

        add_action( 'customize_register', array( $this, 'wp_digest_Back_To_Top_Section_customizer_options' ) );

    }

    /****
        * Customizer options
    ****/
    public function wp_digest_Back_To_Top_Section_customizer_options( $wp_customize ) {

        /*****
            * Markito Theme Back To Top Customizer Section 
        *****/
        $wp_customize->add_section(
            'wp_digest_Theme_Back_To_Top_Section',
            array(
                'title'    => esc_html__( 'Back To Top', 'wp_digest' ),
                'description' => __('Note ::- Here Section You Controll Back To Top Setting Of wp_digest Free Theme...','wp_digest'),
                'priority' => 20,
            )
        );

        $wp_customize->add_setting('wp_digest_Back_To_Top_Section_Visibility',
            array(
                'sanitize_callback' => 'wp_digest_Back_To_Top_sanitize_checkbox_function',
                'default'           => 1,
            )
        );

        $wp_customize->add_control('wp_digest_Back_To_Top_Section_Visibility',
            array(
                'type'        => 'checkbox',
                'label'       => esc_html__('Enable Hide / Show Back To Top.', 'wp_digest'),
                'section'     => 'wp_digest_Theme_Back_To_Top_Section',
                'description' => esc_html__('Check this box to Enable Hide / Show Back To Top.', 'wp_digest'),
            )
        );

		$wp_customize->add_setting( 'wp_digest_Back_To_Top_Button_background', array(
			'default' => '#f05036',
			'sanitize_callback' => 'wp_digest_Back_To_Top_sanitize_color',
		));

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wp_digest_Back_To_Top_Button_background', array(
			'label' => 'Button Background Color',
			'section' => 'wp_digest_Theme_Back_To_Top_Section',
			'settings' => 'wp_digest_Back_To_Top_Button_background'
		)));

		$wp_customize->add_setting( 'wp_digest_Back_To_Top_Button_color_background', array(
			'default' => '#fff',
			'sanitize_callback' => 'wp_digest_Back_To_Top_sanitize_color',
		));

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wp_digest_Back_To_Top_Button_color_background', array(
			'label' => 'Button Icon Color',
			'section' => 'wp_digest_Theme_Back_To_Top_Section',
			'settings' => 'wp_digest_Back_To_Top_Button_color_background'
		)));

        $Back_To_Top_Location_Button = array(
            'Right' => 'Right',
            'Left' => 'Left',     
        );

        $wp_customize->add_setting( 'wp_digest_Back_To_Top_Location_Button', 
            array(
                'default' => 'Right',
                'sanitize_callback' => 'wp_digest_Back_To_Top_Sanitize_Text_Function',
            )
        );

        $wp_customize->add_control( 'wp_digest_Back_To_Top_Location_Button',
            array(
                'type' => 'select',
                'label' => __('Back To Top Button Location','wp_digest'),
                'section' => 'wp_digest_Theme_Back_To_Top_Section',
                'choices' => $Back_To_Top_Location_Button
            )
        );

		/**
		 * Color sanitization callback
		*/
		function wp_digest_Back_To_Top_sanitize_color( $color ) {
			if ( empty( $color ) || is_array( $color ) ) {
				return '';
			}

			// If string does not start with 'rgba', then treat as hex.
			// sanitize the hex color and finally convert hex to rgba
			if ( false === strpos( $color, 'rgba' ) ) {
				return sanitize_hex_color( $color );
			}

			// By now we know the string is formatted as an rgba color so we need to further sanitize it.
			$color = str_replace( ' ', '', $color );
			sscanf( $color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha );

			return 'rgba('.$red.','.$green.','.$blue.','.$alpha.')';
		}

        // markito x Theme Sanitize Function
        function wp_digest_Back_To_Top_Sanitize_Text_Function( $text ) {
            return sanitize_text_field( $text );
        }

        function wp_digest_Back_To_Top_sanitize_checkbox_function( $checked ) {
            // Boolean check.
            return ( ( isset( $checked ) && true == $checked ) ? true : false );
        }

    }

}
endif;
// Call Class 
new wp_digest_Theme_Back_To_Top_Section_Customizer(); 