<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'wp_digest_locale_css' ) ):
    function wp_digest_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'wp_digest_locale_css' );

if ( !function_exists( 'wp_digest_parent_css' ) ):
    function wp_digest_parent_css() {
        wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array(  ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'wp_digest_parent_css', 10 );

// END ENQUEUE PARENT ACTION


function wp_digest_scripts(){
	wp_enqueue_style( 'plugin', get_stylesheet_directory_uri() . '/assets/css/plugin.css' );
	wp_enqueue_script( 'jquery-3.5.1-min', get_stylesheet_directory_uri() . '/assets/js/jquery-3.5.1.min.js' );
	wp_enqueue_script( 'plugin', get_stylesheet_directory_uri() . '/assets/js/plugin.js' );
    wp_enqueue_script( 'custom-swiper3', get_stylesheet_directory_uri() . '/assets/js/custom-swiper3.js',array( 'jquery' ), '', true );

}

add_action('wp_enqueue_scripts', 'wp_digest_scripts');

/**
 * Customizers additions.
*/
require get_stylesheet_directory() . '/customizers.php';

 /**
	 * For Welcome admin notice File...
	*/
	require get_stylesheet_directory() . '/inc/class-back-to-top-customize.php';

function wp_digest_script_footer(){ 
	
	wp_enqueue_script( 'slick-min-js', get_stylesheet_directory_uri() . '/assets/js/slick.min.js');
	wp_enqueue_script( 'main', get_stylesheet_directory_uri() . '/assets/js/main.js' );

} 

add_action('wp_footer', 'wp_digest_script_footer'); 

add_action( 'after_setup_theme', 'wp_digest_add_cat' );

function wp_digest_add_cat() {
	
	add_theme_support( 'title-tag' );

	add_theme_support( 'automatic-feed-links' );

	add_theme_support( 'register_block_style' );

	add_theme_support( 'register_block_pattern' );

	add_theme_support( 'responsive-embeds' );

	add_theme_support( 'wp-block-styles' );

	add_theme_support( 'align-wide' );

	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
    //Create Custom Category
    wp_insert_term(
    'Home Slider', 
    'category', 
    array('slug' => 'home-slider')
    );
	
	wp_insert_term(
    'Trending News', 
    'category', 
    array('slug' => 'trending-news')
    );
	
}

function wp_digest_excerpt_length( $length ) {
    return 20;
}
add_filter( 'excerpt_length', 'wp_digest_excerpt_length', 999 );