<?php get_header() ?>

<section class="banner overflow-hidden">
	<div class="slider slider1">
		<div class="swiper-container ">
			<div class="swiper-wrapper ">
			<?php  $banner_category = get_theme_mod( 'banner_category' );
			$result = new WP_Query( array(
				'post_type' => 'post',
				'orderby'    => 'ID',
				'cat' => $banner_category,
				'post_status' => 'publish',
				'posts_per_page' => 6
			));
			while($result -> have_posts()) { $result -> the_post(); ?>
				<div class="swiper-slide ">
					<div class="slide-inner ">
						<div class="slide-image " style="background-image:url('<?php the_post_thumbnail_url(); ?>') "></div>
						<div class="swiper-content p-4 ">
							<div class="entry-meta d-flex align-items-center justify-content-between ">
								<span class="entry-category me-2 white bg-2 py-1 px-3 "><?php the_category( ' , ' ); ?></span>
							</div>
							<h1 class="mb-2 s-title1 "><a href="<?php echo the_permalink(); ?>"><?php the_title() ?></a></h1>
							<div class="entry-meta d-flex align-items-center ">
								<ul>
									<li class="me-2"><i class="fa fa-user "></i> <?php the_author(); ?></li>
									<li class="me-2"><i class="fa-solid fa-calendar-days"></i> <?php echo esc_html( get_the_date() ); ?></li>
									<li><i class="fa fa-comments"></i> <?php echo esc_html(get_comments_number()); ?></li>
								</ul>
							</div>
						</div>
						<div class="overlay "></div>
					</div>
				</div>        
			<?php } ?>
			</div>
		</div>
	</div>
	<div class="swiper-button-next "></div>
	<div class="swiper-button-prev "></div>
</section>

<section class="breaking-news pt-3 pb-3">
	<div class="container">
		<div class="breaking-news py-2 px-4 bg-2 w-100 d-md-flex align-items-center justify-content-between">
			<h4 class="white mb-0 w-25 fw-normal me-3 d-flex align-items-center"><i class="fas fa-bolt me-2"></i> <?php esc_html_e('RecentNews','wp-digest'); ?></h4>
			<div class="links float-right">
				<marquee scrolldelay="50" behavior="scroll" onmouseover="this.stop();" onmouseleave="this.start();">
					<?php  
					$blogs_args = array(
						'post_type' => 'post',
						'posts_per_page' => 10

					);
					$blog_posts = new WP_Query($blogs_args);
					while($blog_posts->have_posts()) { $blog_posts->the_post();?>
					<li class="d-inline-block"><a href="<?php echo the_permalink(); ?>" class="white"><i class="fa fa-star"></i> <?php the_title(); ?></a></li>
					<?php } ?>
				</marquee>
			</div>
		</div>
	</div>
</section>

<section class="trending section-padding1">
	<div class="container">
		<div class="section-title mb-4 pb-1 w-50">
			<h2 class="m-0"><?php esc_html_e('Trending','wp-digest'); ?> <span> <?php esc_html_e('News','wp-digest'); ?></span></h2>
		</div>
		<div class="about-image-box">
			<div class="row trending-news-slider">
				<?php  $featured_category = get_theme_mod( 'featured_category' );
				$result = new WP_Query( array(
					'post_type' => 'post',
					'orderby'    => 'ID',
					'cat' => $featured_category,
					'post_status' => 'publish',
					'posts_per_page' => 6
				));
				while($result -> have_posts()) { $result -> the_post(); ?>
				<div class="col-lg-4">
					<div class="trend-item box-shadow bg-white">
						<div class="trend-image">
						   <a href="<?php echo the_permalink() ?>"><?php the_post_thumbnail();?></a>
						</div>
						<div class="trend-content-main p-4">
							<div class="trend-content">
								<h5 class="theme"><?php the_category( ' , ' ); ?></h5>
								<h4><a href="<?php echo the_permalink(); ?>"><?php the_title() ?></a></h4>
								<p class="mb-2"><?php the_excerpt() ?></p>
								<div class="entry-meta d-flex align-items-center justify-content-between">
									<div class="entry-author">
										<img src="<?php echo esc_url(get_avatar_url(get_current_user_id(), ['size' => '60'])); ?>" alt="testi-1" class="rounded-circle me-1">
										<span> <?php the_author(); ?></span>
									</div>
									<div class="entry-metalist d-flex align-items-center">
										<ul>
											<li class="me-2"><i class="fa-solid fa-calendar-days"></i> <?php echo esc_html( get_the_date() ); ?></li>
											<li><i class="fa fa-comments"></i> <?php echo esc_html(get_comments_number()); ?></li>
										</ul>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>
	</div>
</section>

<section class="trending more-top-news section-padding1  pbottom">
	<div class="container">
		<div class="section-title mb-4 pb-1 w-50">
			<h2 class="m-0"><?php esc_html_e('More Top','wp-digest'); ?> <span> <?php echo esc_html_e('News','wp-digest'); ?></span></h2>
		</div>
		<div class="trend-box">
			<div class="row">
				<div class="col-lg-8">
					<?php  
					$blogs_args = array(
						'post_type' => 'post',
						'posts_per_page' => 5
					);
					$blog_posts = new WP_Query($blogs_args);
					while($blog_posts->have_posts()) { $blog_posts->the_post(); ?>
					<div class="trend-item box-shadow bg-white p-4 mb-4">
						<div class="row">
							<div class="col-lg-4">
								<div class="trend-image1">
									<a href="<?php the_permalink() ?>"><?php the_post_thumbnail();?></a>
								</div>
							</div>
							<div class="col-lg-8">
								<div class="trend-content-main">
									<div class="trend-content">
										<h5 class="theme"><?php the_category( ' , ' ); ?></h5>
										<h4><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h4>
										<p class="mb-2"> <?php the_excerpt() ?></p>
										<div class="entry-meta d-flex align-items-center justify-content-between">
											<div class="entry-author">
												<img src="<?php echo esc_url(get_avatar_url(get_current_user_id(), ['size' => '60'])); ?>" alt="testi-1" class="rounded-circle me-1">
												<span><?php the_author(); ?></span>
											</div>
											<div class="entry-metalist d-flex align-items-center">
											<ul>
											<li class="me-2"><i class="fa-solid fa-calendar-days"></i> <?php echo esc_html( get_the_date() ); ?></li>
											<li><i class="fa fa-comments"></i> <?php echo esc_html(get_comments_number()); ?></li>
											</ul>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php } ?>				
				</div>
				<div class="col-lg-4 col-md-12">
					<div class="sidebar-sticky">
					   <?php get_sidebar(); ?>
					</div>  
				</div>
			</div>
		</div>
	</div>
</section>
<section class="top-post section-padding1">
	<div class="container">
		<div class="section-title mb-4 pb-1 w-50">
			<h2 class="m-0"> <?php esc_html_e('Related','wp-digest'); ?> <span> <?php esc_html_e('News Posts','wp-digest'); ?></span></h2>
		</div>
		<div class="row related-post-slider">
		<?php  $banner_category = get_theme_mod( 'banner_category' );
			$result = new WP_Query( array(
				'post_type' => 'post',
				'orderby'    => 'ID',
				'cat' => $banner_category,
				'post_status' => 'publish',
				'posts_per_page' => 6
			));
			while($result -> have_posts()) { $result -> the_post(); ?>
			<div class="col-lg-4">
				<div class="trend-item">
					<div class="trend-image">
					<a href="<?php the_permalink() ?>">
						   <?php the_post_thumbnail();?>
						   </a>
						<div class="trend-content">
							<h5 class="theme"><?php the_category( ' , ' ); ?></h5>
							<h4><a href="<?php echo the_permalink(); ?>"><?php the_title() ?></a></h4>
									   
							<div class="entry-meta d-flex align-items-center justify-content-between">
								<div class="entry-author d-flex align-items-center">
									<img src="<?php echo esc_url(get_avatar_url(get_current_user_id(), ['size' => '60'])); ?>" alt="testi-1" class="rounded-circle me-1">
									<span> <?php the_author(); ?></span>
								</div>
								<div class="entry-metalist">
									<small><i class="fa fa-calendar"></i> <?php echo esc_html( get_the_date() ); ?></small>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</section>
<?php get_footer() ?>