<?php
/**
 * The template for displaying the footer
 *
 * @package wp-digest
 * @since 0.1
 */
	if(get_theme_mod('footer_widgets_show','true')==true) { ?>
    <div class="container-fluid bg-light pt-5 px-sm-3 px-md-5">
        <div class="row">
		
			<?php
				if ( is_active_sidebar( 'footer-widget' ) ) {
					dynamic_sidebar( 'footer-widget' );
				} else {
					$mediapulse_widget = get_theme_mod('footer_widget_layout',3);
					$mediapulse_args = array(
						'before_widget' => '<div id="%1$s" class="news-widget col-lg-'.$mediapulse_widget.' col-md-6 mb-5">',
						'after_widget'  => '</div>',
						'before_title'  => '<h4 class="font-weight-bold mb-4">',
						'after_title'   => '</h4>',
					);
					the_widget('WP_Widget_Calendar', 'title='.__('Calendar', 'wp-digest'), $mediapulse_args);
					the_widget( 'WP_Widget_Pages', null, $mediapulse_args );
					the_widget('WP_Widget_Recent_Posts', null, $mediapulse_args);
					the_widget('WP_Widget_Archives', null, $mediapulse_args);
				}
			?>
            
        </div>
    </div>
	<?php } ?>
    <div class="container-fluid bg-subfooter py-3 px-sm-3 px-md-5">
        <p class="m-0 text-center footer-color">
			<?php $mediapulse_footer_url = get_theme_mod('footer_url','#'); 
			$mediapulse_footer_text = get_theme_mod('footer_text','Infigo Software, All Rights Reserved. Designed by Infigo Software'); ?>
            &copy; <a class="font-weight-bold" href="<?php echo esc_url( $mediapulse_footer_url ); ?>"> <?php echo esc_html( $mediapulse_footer_text ); ?> </a>
        </p>
    </div>
	
	<?php $wp_digest_Back_To_Top_Button_background = get_theme_mod('wp_digest_Back_To_Top_Button_background');
if( !empty($wp_digest_Back_To_Top_Button_background) ) : ?>

   <style>
      #btn-to-top {
         display: inline-block;
         width: 40px;
         height: 40px;
         background-color: <?php echo $wp_digest_Back_To_Top_Button_background; ?> !important;
         text-align: center;
         position: fixed;
         bottom: 90px;
         right: 35px;
         z-index: 999;
         transform: scale(1.1,1.1);
         transition: all 0.5s ease;
      }
   </style>    
                
<?php endif; ?>

<?php $wp_digest_Back_To_Top_Button_color_background = get_theme_mod('wp_digest_Back_To_Top_Button_color_background');
   if( !empty($wp_digest_Back_To_Top_Button_color_background) ) : ?>

      <style>

         a#btn-to-top i {
            font-size: 20px;
            color: <?php echo $wp_digest_Back_To_Top_Button_color_background; ?> !important;
            line-height: 2.1;
         }

      </style>    
                
<?php endif; ?>

<?php 
$wp_digest_Back_To_Top_Location_Button = get_theme_mod('wp_digest_Back_To_Top_Location_Button', 'Right'); 
if( $wp_digest_Back_To_Top_Location_Button === "Left" ) :
   ?>

   <style>
   #btn-to-top {
      opacity: 1;
      visibility: visible;
      left: 10%;
      position: fixed;
   }
   </style>  

   <?php

endif;
?>                             

<!--- scroll-to-top -->
<?php $wp_digest_Back_To_Top_Section_Visibility = get_theme_mod( 'wp_digest_Back_To_Top_Section_Visibility' ,1 );
if( $wp_digest_Back_To_Top_Section_Visibility ) : ?>
   <a href="#" id="btn-to-top"><i class="fas fa-arrow-up"></i></a>
<?php endif; ?>


<?php get_template_part( 'custom', 'font' ); ?>
<?php wp_footer(); ?>
</body>

</html>