<?php

/**
 * Title: Testimonial Section
 * Slug: woxstore/testimonial-section
 * Categories: woxstore
 */
$woxstore_url = trailingslashit(get_template_directory_uri());
$woxstore_images = array(
    $woxstore_url . 'assets/images/testimonial_1.jpg',
    $woxstore_url . 'assets/images/rating_star.png',
);
?>
<!-- wp:group {"metadata":{"categories":["woxstore"],"patternName":"woxstore/testimonial-section","name":"Testimonial Section"},"style":{"spacing":{"padding":{"top":"6rem","bottom":"3rem","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"margin":{"top":"0px","bottom":"0px"}}},"backgroundColor":"light-color","layout":{"type":"constrained","contentSize":"1180px"}} -->
<div class="wp-block-group has-light-color-background-color has-background" style="margin-top:0px;margin-bottom:0px;padding-top:6rem;padding-right:var(--wp--preset--spacing--40);padding-bottom:3rem;padding-left:var(--wp--preset--spacing--40)"><!-- wp:group {"style":{"spacing":{"margin":{"bottom":"60px"}}},"layout":{"type":"constrained","contentSize":"640px","justifyContent":"center"}} -->
    <div class="wp-block-group" style="margin-bottom:60px"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"jumbo"} -->
        <h2 class="wp-block-heading has-text-align-center has-jumbo-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e('Hear From Our Happy Customers', 'woxstore') ?></h2>
        <!-- /wp:heading -->
    </div>
    <!-- /wp:group -->

    <!-- wp:group {"style":{"border":{"radius":"0px","width":"0px","style":"none"},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained","contentSize":"580px"}} -->
    <div class="wp-block-group" style="border-style:none;border-width:0px;border-radius:0px;margin-top:0;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
        <div class="wp-block-group"><!-- wp:image {"id":2415,"width":"auto","height":"60px","aspectRatio":"1","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"50px"}}} -->
            <figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url($woxstore_images[0]) ?>" alt="" class="wp-image-2415" style="border-radius:50px;aspect-ratio:1;object-fit:cover;width:auto;height:60px" /></figure>
            <!-- /wp:image -->

            <!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
            <div class="wp-block-group"><!-- wp:heading {"level":5,"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}}},"textColor":"heading-color","fontSize":"large"} -->
                <h5 class="wp-block-heading has-heading-color-color has-text-color has-link-color has-large-font-size"><?php esc_html_e('Robert Matt', 'woxstore') ?></h5>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"}}},"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"primary"} -->
                <p class="has-primary-color has-text-color has-link-color" style="font-style:normal;font-weight:300"><?php esc_html_e('Fitness Coach', 'woxstore') ?></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->

        <!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"typography":{"fontStyle":"italic","fontWeight":"400"}},"textColor":"foreground","fontSize":"large"} -->
        <p class="has-text-align-center has-foreground-color has-text-color has-link-color has-large-font-size" style="font-style:italic;font-weight:400"><?php esc_html_e('I’m so impressed with the variety and quality of clothing! Everything I’ve ordered looks just like the pictures and fits perfectly. Plus, customer service is super helpful. Highly recommend!', 'woxstore') ?></p>
        <!-- /wp:paragraph -->

        <!-- wp:image {"id":4435,"width":"94px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
        <figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url($woxstore_images[1]) ?>" alt="" class="wp-image-4435" style="width:94px" /></figure>
        <!-- /wp:image -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->