<?php

/**
 * Title: Call to Action
 * Slug: woxstore/cta-block
 * Categories: woxstore
 */
$woxstore_url = trailingslashit(get_template_directory_uri());
$woxstore_images = array(
    $woxstore_url . 'assets/images/cta_bg.jpg',
);
?>
<!-- wp:group {"style":{"spacing":{"padding":{"right":"0","left":"0","top":"0","bottom":"0"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"<?php echo esc_url($woxstore_images[0]) ?>","id":11161,"dimRatio":20,"overlayColor":"black-color","isUserOverlayColor":true,"minHeight":580,"isDark":false,"layout":{"type":"constrained","contentSize":"1180px"}} -->
    <div class="wp-block-cover is-light" style="min-height:580px"><span aria-hidden="true" class="wp-block-cover__background has-black-color-background-color has-background-dim-20 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-11161" alt="" src="<?php echo esc_url($woxstore_images[0]) ?>" data-object-fit="cover" />
        <div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained","contentSize":"680px","justifyContent":"right"}} -->
            <div class="wp-block-group"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"300"}},"textColor":"light-color","fontSize":"medium"} -->
                <p class="has-light-color-color has-text-color has-link-color has-medium-font-size" style="font-style:normal;font-weight:300;text-transform:uppercase"><?php esc_html_e('Limited Offers 75% Off – Todays!', 'woxstore') ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:heading {"level":1,"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"typography":{"textTransform":"uppercase","lineHeight":"1.3"}},"textColor":"light-color","fontSize":"mega"} -->
                <h1 class="wp-block-heading has-light-color-color has-text-color has-link-color has-mega-font-size" style="line-height:1.3;text-transform:uppercase"><?php esc_html_e('Revered for Sophisticated Looks', 'woxstore') ?></h1>
                <!-- /wp:heading -->

                <!-- wp:buttons {"className":"is-style-button-transofom-on-hover","style":{"spacing":{"margin":{"top":"40px"}}},"layout":{"type":"flex","justifyContent":"left"}} -->
                <div class="wp-block-buttons is-style-button-transofom-on-hover" style="margin-top:40px"><!-- wp:button {"backgroundColor":"transparent","textColor":"light-color","className":"is-style-button-hover-primary-bgcolor","style":{"spacing":{"padding":{"left":"40px","right":"40px","top":"20px","bottom":"20px"}},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"border":{"width":"1px","radius":"0px"},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"300"}}} -->
                    <div class="wp-block-button is-style-button-hover-primary-bgcolor" style="font-style:normal;font-weight:300;text-transform:uppercase"><a class="wp-block-button__link has-light-color-color has-transparent-background-color has-text-color has-background has-link-color wp-element-button" style="border-width:1px;border-radius:0px;padding-top:20px;padding-right:40px;padding-bottom:20px;padding-left:40px"><?php esc_html_e('View All Collections', 'woxstore') ?></a></div>
                    <!-- /wp:button -->
                </div>
                <!-- /wp:buttons -->
            </div>
            <!-- /wp:group -->
        </div>
    </div>
    <!-- /wp:cover -->
</div>
<!-- /wp:group -->