<?php

/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package woxstore
 * @since 1.0.0
 */

if (function_exists('register_block_style')) {
    /**
     * Register block styles.
     *
     * @since 0.1
     *
     * @return void
     */
    function woxstore_register_block_styles()
    {
        register_block_style(
            'core/columns',
            array(
                'name'  => 'woxstore-boxshadow',
                'label' => __('Box Shadow', 'woxstore')
            )
        );

        register_block_style(
            'core/column',
            array(
                'name'  => 'woxstore-boxshadow',
                'label' => __('Box Shadow', 'woxstore')
            )
        );
        register_block_style(
            'core/column',
            array(
                'name'  => 'woxstore-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'woxstore')
            )
        );
        register_block_style(
            'core/column',
            array(
                'name'  => 'woxstore-boxshadow-large',
                'label' => __('Box Shadow Large', 'woxstore')
            )
        );

        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-boxshadow',
                'label' => __('Box Shadow', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-boxshadow-large',
                'label' => __('Box Shadow Larger', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-gradient-border',
                'label' => __('Gradient Border Primary', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-gradient-border',
                'label' => __('Gradient Border Style', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-product-holder',
                'label' => __('Product Group', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-product-group',
                'label' => __('Product Image Group', 'woxstore')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-overlay-navigaion',
                'label' => __('Overlay Navigation', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-boxshadow',
                'label' => __('Box Shadow', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-boxshadow-larger',
                'label' => __('Box Shadow Large', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-image-pulse',
                'label' => __('Iamge Pulse Effect', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-image-hover-pulse',
                'label' => __('Pulse Effect on Hover', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-image-hover-rotate',
                'label' => __('Rotate On Hover', 'woxstore')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'woxstore-image-hover-zoom',
                'label' => __('Zoom On Hover', 'woxstore')
            )
        );
        register_block_style(
            'core/columns',
            array(
                'name'  => 'woxstore-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'woxstore')
            )
        );

        register_block_style(
            'core/column',
            array(
                'name'  => 'woxstore-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'woxstore')
            )
        );

        register_block_style(
            'core/group',
            array(
                'name'  => 'woxstore-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'woxstore')
            )
        );

        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-round',
                'label' => __('Background', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-primary-color',
                'label' => __('Hover: Primary Color', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-secondary-color',
                'label' => __('Hover: Secondary Color', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-primary-bgcolor',
                'label' => __('Hover: Primary color fill', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-secondary-bgcolor',
                'label' => __('Hover: Secondary color fill', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-with-arrow-icon',
                'label' => __('Arrow Icon', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-with-uparrow-icon',
                'label' => __('Upward Arrow Icon', 'woxstore')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-with-gradient-border',
                'label' => __('Gradient Border', 'woxstore')
            )
        );
        register_block_style(
            'core/buttons',
            array(
                'name'  => 'button-transofom-on-hover',
                'label' => __('Translate On Hover', 'woxstore')
            )
        );
        register_block_style(
            'core/buttons',
            array(
                'name'  => 'button-zoom-on-hover',
                'label' => __('Zoom On Hover', 'woxstore')
            )
        );

        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-primary-color',
                'label' => __('Hover: Primary Color', 'woxstore')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-secondary-color',
                'label' => __('Hover: Secondary Color', 'woxstore')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-primary-fill',
                'label' => __('Hover: Primary Fill', 'woxstore')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-secondary-fill',
                'label' => __('Hover: secondary Fill', 'woxstore')
            )
        );

        register_block_style(
            'core/list',
            array(
                'name'  => 'list-style-no-bullet',
                'label' => __('Hide bullet', 'woxstore')
            )
        );
        register_block_style(
            'core/list',
            array(
                'name'  => 'list-style-check-circle',
                'label' => __('Check Circle Primary', 'woxstore')
            )
        );
        register_block_style(
            'core/list',
            array(
                'name'  => 'list-style-check-circle-white',
                'label' => __('Check Circle white', 'woxstore')
            )
        );


        register_block_style(
            'core/gallery',
            array(
                'name'  => 'enable-grayscale-mode-on-image',
                'label' => __('Enable Grayscale Mode on Image', 'woxstore')
            )
        );
        register_block_style(
            'core/social-links',
            array(
                'name'  => 'social-icon-border',
                'label' => __('Border Style', 'woxstore')
            )
        );
        register_block_style(
            'core/page-list',
            array(
                'name'  => 'woxstore-page-list-bullet-hide-style',
                'label' => __('Hide Bullet Style', 'woxstore')
            )
        );
        register_block_style(
            'core/categories',
            array(
                'name'  => 'woxstore-categories-bullet-hide-style',
                'label' => __('Hide Bullet Style', 'woxstore')
            )
        );
        register_block_style(
            'core/cover',
            array(
                'name'  => 'woxstore-cover-unset-overflow',
                'label' => __('Unset Overflow', 'woxstore')
            )
        );
        register_block_style(
            'core/cover',
            array(
                'name'  => 'woxstore-cover-overlay-style',
                'label' => __('Overlay Style', 'woxstore')
            )
        );
        register_block_style(
            'core/cover',
            array(
                'name'  => 'woxstore-cover-hover-style',
                'label' => __('Hover Style', 'woxstore')
            )
        );
        register_block_style(
            'core/navigation',
            array(
                'name'  => 'woxstore-navigation-enable-menu-description',
                'label' => __('Enable Menu Description', 'woxstore')
            )
        );
        register_block_style(
            'core/wp-block-navigation-item',
            array(
                'name'  => 'woxstore-navigation-item-secondary',
                'label' => __('Secondary Color Description', 'woxstore')
            )
        );
    }
    add_action('init', 'woxstore_register_block_styles');
}
