<?php

/**
 * woxstore: Block Patterns
 *
 * @since woxstore 1.0.0
 */

/**
 * Registers pattern categories for woxstore
 *
 * @since woxstore 1.0.0
 *
 * @return void
 */
function woxstore_register_pattern_category()
{
	$block_pattern_categories = array(
		'woxstore' => array('label' => __('WoxStore Sections', 'woxstore')),
		'woxstore-homes' => array('label' => __('Homepage Templates', 'woxstore')),
	);

	$block_pattern_categories = apply_filters('woxstore_block_pattern_categories', $block_pattern_categories);

	foreach ($block_pattern_categories as $name => $properties) {
		if (!WP_Block_Pattern_Categories_Registry::get_instance()->is_registered($name)) {
			register_block_pattern_category($name, $properties); // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_pattern_category
		}
	}
}
add_action('init', 'woxstore_register_pattern_category', 9);
