<?php
$themes = array(
	trailingslashit( get_template_directory_uri() ) . 'inc/admin/images/saaslauncher.webp',
	trailingslashit( get_template_directory_uri() ) . 'inc/admin/images/fotawp.webp',
	trailingslashit( get_template_directory_uri() ) . 'inc/admin/images/jetnews-magazine.webp',
);
?>

<div class="woxstore-page__products">
	<h3><?php esc_html_e( 'Our Themes', 'woxstore' ); ?></h3>
	<ul class="products-collection themes-collection">
		<li class="product product-theme">
			<figure class="product-image theme-image">
				<a href="https://cozythemes.com/saaslauncher-wordpress-theme/" target="_blank">
					<img src="<?php echo esc_url( $themes[0] ); ?>" />
				</a>
			</figure>
			<h4 class="product-title">
				<a href="https://cozythemes.com/saaslauncher-wordpress-theme/" target="_blank">
					<?php esc_html_e( 'SaasLauncher', 'woxstore' ); ?>
				</a>
			</h4>
			<p class="product-desc"><?php esc_html_e( 'SaasLauncher is a modern, block-based WordPress theme crafted specifically for SaaS products, startups, agencies, and businesses.', 'woxstore' ); ?></p>
		</li>
		<li class="product product-theme">
			<figure class="product-image theme-image">
				<a href="https://cozythemes.com/fotawp/" target="_blank">
					<img src="<?php echo esc_url( $themes[1] ); ?>" />
				</a>
			</figure>
			<h4 class="product-title">
				<a href="https://cozythemes.com/fotawp/" target="_blank">
					<?php esc_html_e( 'FotaWP', 'woxstore' ); ?>
				</a>
			</h4>
			<p class="product-desc"><?php esc_html_e( 'FotaWP is a powerful multipurpose WordPress theme designed to make website building fast, flexible, and effortless.', 'woxstore' ); ?></p>
		</li>
		<li class="product product-theme">
			<figure class="product-image theme-image">
				<a href="https://cozythemes.com/jetnews-magazine-wordpress-theme/" target="_blank">
					<img src="<?php echo esc_url( $themes[2] ); ?>" />
				</a>
			</figure>
			<h4 class="product-title">
				<a href="https://cozythemes.com/jetnews-magazine-wordpress-theme/" target="_blank">
					<?php esc_html_e( 'Jetnews Magazine', 'woxstore' ); ?>
				</a>
			</h4>
			<p class="product-desc"><?php esc_html_e( 'JetNews Magazine makes it simple to build a professional blog or magazine site. Ideal for news, magazines, and publishing platforms.', 'woxstore' ); ?></p>
		</li>
	</ul>

	<br /><br />

	<h3><?php esc_html_e( 'Our Plugins', 'woxstore' ); ?></h3>
	<ul class="products-collection plugins-collection">
		<li class="product product-plugin">
			<figure class="product-image plugin-image">
				<img src="https://plugins.svn.wordpress.org/cozy-addons/assets/icon-128x128.gif" />
			</figure>
			<h4 class="product-title"><?php esc_html_e( 'Cozy Blocks', 'woxstore' ); ?></h4>
		</li>
		<li class="product product-plugin">
			<figure class="product-image plugin-image">
				<img src="https://plugins.svn.wordpress.org/cozy-essential-addons/assets/icon-128x128.png" />
			</figure>
			<h4 class="product-title"><?php esc_html_e( 'Cozy Essential Addons', 'woxstore' ); ?></h4>
		</li>
		<li class="product product-plugin">
			<figure class="product-image plugin-image">
				<img src="https://plugins.svn.wordpress.org/rootblox/assets/icon-128x128.png" />
			</figure>
			<h4 class="product-title"><?php esc_html_e( 'Rootblox', 'woxstore' ); ?></h4>
		</li>
	</ul>
</div>