<?php
if ( ! defined( 'WOXSTORE_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'WOXSTORE_VERSION', wp_get_theme()->get( 'Version' ) );
}
define( 'WOXSTORE_DEBUG', defined( 'WP_DEBUG' ) && WP_DEBUG === true );
define( 'WOXSTORE_DIR', trailingslashit( get_template_directory() ) );
define( 'WOXSTORE_URL', trailingslashit( get_template_directory_uri() ) );

if ( ! function_exists( 'woxstore_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since walker_fse 1.0.0
	 *
	 * @return void
	 */
	function woxstore_support() {
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'post-thumbnails' );
		// Enqueue editor styles.
		add_editor_style( 'style.css' );
		// Removing default patterns.
		remove_theme_support( 'core-block-patterns' );
	}

endif;
add_action( 'after_setup_theme', 'woxstore_support' );

/*
----------------------------------------------------------------------------------
Enqueue Styles
-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'woxstore_styles' ) ) :
	function woxstore_styles() {
		// registering style for theme
		wp_enqueue_style( 'woxstore-style', get_stylesheet_uri(), array(), WOXSTORE_VERSION );
		wp_enqueue_style( 'woxstore-blocks-style', get_template_directory_uri() . '/assets/css/blocks.css', array(), WOXSTORE_VERSION );
		wp_enqueue_style( 'woxstore-aos-style', get_template_directory_uri() . '/assets/css/aos.css', array(), WOXSTORE_VERSION );
		if ( is_rtl() ) {
			wp_enqueue_style( 'woxstore-rtl-css', get_template_directory_uri() . '/assets/css/rtl.css', 'rtl_css', WOXSTORE_VERSION );
		}
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'woxstore-aos-scripts', get_template_directory_uri() . '/assets/js/aos.js', array(), WOXSTORE_VERSION, true );
		wp_enqueue_script( 'woxstore-scripts', get_template_directory_uri() . '/assets/js/woxstore-scripts.js', array(), WOXSTORE_VERSION, true );
	}
endif;

add_action( 'wp_enqueue_scripts', 'woxstore_styles' );

/**
 * Enqueue scripts for admin area
 */
function woxstore_admin_style() {
	if ( function_exists( 'get_current_screen' ) ) {
		$woxstore_notice_current_screen = get_current_screen();

		if ( ( ! empty( $_GET['page'] ) && 'about-woxstore' === $_GET['page'] ) || $woxstore_notice_current_screen->id === 'themes' || $woxstore_notice_current_screen->id === 'dashboard' || $woxstore_notice_current_screen->id === 'plugins' ) {
			wp_enqueue_style( 'woxstore-admin-style', get_template_directory_uri() . '/inc/admin/css/admin-style.css', array(), WOXSTORE_VERSION, 'all' );
			wp_enqueue_script( 'woxstore-admin-scripts', get_template_directory_uri() . '/inc/admin/js/woxstore-admin-scripts.js', array( 'jquery' ), WOXSTORE_VERSION, true );
			wp_localize_script(
				'woxstore-admin-scripts',
				'woxstore_admin_localize',
				array(
					'ajax_url'     => admin_url( 'admin-ajax.php' ),
					'nonce'        => wp_create_nonce( 'woxstore_admin_nonce' ),
					'welcomeNonce' => wp_create_nonce( 'woxstore_welcome_nonce' ),
					'redirect_url' => admin_url( 'themes.php?page=about-woxstore' ),
					'scrollURL'    => admin_url( 'plugins.php?cozy-addons-scroll=true' ),
					'demoURL'      => admin_url( 'themes.php?page=advanced-import' ),
				)
			);
		}
	}
}
add_action( 'admin_enqueue_scripts', 'woxstore_admin_style' );

/**
 * Enqueue assets scripts for both backend and frontend
 */
function woxstore_block_assets() {
	wp_enqueue_style( 'woxstore-swiper-bundle-editor-style', get_template_directory_uri() . '/assets/css/swiper-bundle.css', array(), WOXSTORE_VERSION );
	wp_enqueue_style( 'woxstore-blocks-style', get_template_directory_uri() . '/assets/css/blocks.css' );
	wp_enqueue_script( 'woxstore-swiper-bundle-editor-scripts', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array(), WOXSTORE_VERSION, true );
}
add_action( 'enqueue_block_assets', 'woxstore_block_assets' );

/**
 * Load core file.
 */
require_once get_template_directory() . '/inc/core/init.php';

/**
 * Load welcome page file.
 */
require_once get_template_directory() . '/inc/admin/welcome-notice.php';

if ( ! function_exists( 'woxstore_excerpt_more_postfix' ) ) {
	function woxstore_excerpt_more_postfix( $more ) {
		if ( is_admin() ) {
			return $more;
		}
		return '...';
	}
	add_filter( 'excerpt_more', 'woxstore_excerpt_more_postfix' );
}
function woxstore_add_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'woxstore_add_woocommerce_support' );
