<?php
/**
 * The template for displaying Header.
 *
 * @package wholesales
 */
?>


<header class="header-one-area header-style-two">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="header-one">
					<?php do_action('wholesales_header_logo_ready'); ?>
					<?php do_action('wholesales_header_menu_ready'); ?>
					<?php
						$menu_info_button = wholesales_get_options( 'menu_info_button' );
						if($menu_info_button) : 
					?>
						<div class="wholesales-o-search-header">
							<div class="wholesales-o-search-header-icon">
								<button>
									<?php echo wp_kses($menu_info_button, 'code_contxt'); ?>
								</button>
							</div>
						</div>
					<?php
						endif;
					?>
					<button  class="header-one-menu-toggle-area">
						<svg version="1.1" id="Menu" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
							viewBox="0 0 20 20" enable-background="new 0 0 20 20" xml:space="preserve">
						<path class="three-dash"  d="M16.4,9H3.6C3.048,9,3,9.447,3,10c0,0.553,0.048,1,0.6,1h12.8c0.552,0,0.6-0.447,0.6-1S16.952,9,16.4,9z
							M16.4,13H3.6C3.048,13,3,13.447,3,14c0,0.553,0.048,1,0.6,1h12.8c0.552,0,0.6-0.447,0.6-1S16.952,13,16.4,13z M3.6,7h12.8
							C16.952,7,17,6.553,17,6s-0.048-1-0.6-1H3.6C3.048,5,3,5.447,3,6S3.048,7,3.6,7z"/>
						</svg>
					</button >
				</div>
			</div>
		</div>
	</div>
	<?php do_action('wholesales_mobile_part_ready'); ?>
</header>


<div class="wholesales-search-area">
	<div class="wholesales-search">
		<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-circle close-search-icon" viewBox="0 0 16 16">
			<path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
			<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
		</svg>
		<?php
			get_search_form();
		?>
	</div>
</div>