<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package wholesales
 */

get_header();
    if (is_active_sidebar('sidebar-1')) :
        $wholesales_blog_post_list_class = 'col-lg-8';
    else :
        $wholesales_blog_post_list_class = 'col-lg-12';
    endif;
?>
	<section  id="content-start" class="blog-listing-area-one" id="content-start">
		<div class="container">
			<div class="row">
				<div class="<?php echo esc_attr($wholesales_blog_post_list_class); ?> col-md-12 col-sm-12">
					<div class="blog-listing">
						<?php
							if (have_posts()) :
								
								while (have_posts()) :
									the_post();
									get_template_part('template-parts/blog-layout/blog-standard-content');

								endwhile;
							else :
								get_template_part('template-parts/content', 'none');
							endif;
						?>
					</div>
					<?php if(get_the_posts_pagination()) : ?>
						<div class="pagination-box col-md-12">
							<?php
								the_posts_pagination(array(
									'mid_size' => 2,
									'prev_text' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16"> <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/> </svg>',
                                	'next_text' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16"> <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"/> </svg>'
								));
							?>
						</div>
					<?php endif; ?>
				</div>
				<?php if (is_active_sidebar('sidebar-1')) { ?>
					<div class="col-lg-4 col-md-12 col-sm-12">
						<aside class="blog-sidebar-one">
							<?php get_sidebar(); ?>
						</aside>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
<?php
get_footer();
