<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package wholesales
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function wholesales_body_classes( $classes ) {
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
    }

	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
    }
	return $classes;
}
add_filter( 'body_class', 'wholesales_body_classes' );

function wholesales_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'wholesales_pingback_header' );