<?php
/**
 * TGM setup
 *
 * @package wholesales\TGM
 */

namespace wholesales\TGM;

// This file contains the TMGPA class for installing plugins, not template partials.
// phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require_once get_parent_theme_file_path( 'inc/framework/tgm/class-tgm-plugin-activation.php' );

/**
 * Set up TGM hooks
 *
 * @return void
 */
function setup() {
	$n = function( $function ) {
		return __NAMESPACE__ . "\\$function";
	};

	add_action( 'tgmpa_register', $n( 'register_required_plugins' ) );
}

/**
 * Register the required plugins.
 *
 * @return void
 */
function register_required_plugins() {
	$plugins = array(
		array(
			'name'     => 'Modalvideo',
			'slug'     => 'video-lightbox-block',
			'required' => false,   
		),
		array(
			'name'     => 'Blockplayer',
			'slug'     => 'blockplayer',
			'required' => false,   
		),
		array(
			'name'     => 'Breadcrumb Navxt',
			'slug'     => 'breadcrumb-navxt',
			'required' => false,   
		),
		array(
			'name'     => 'Redux Framework',
			'slug'     => 'redux-framework',
			'required' => false,   
		),
		array(
			'name'     => 'Contact Form 7',
			'slug'     => 'contact-form-7',
			'required' => false,   
		),
		array(
			'name'     => 'Elementor',
			'slug'     => 'elementor',
			'required' => false,   
		),
		array(
			'name'     => 'Meta Box',
			'slug'     => 'meta-box',
			'required' => false,   
		),
	);

	/**
	 * Filters the list of plugin depedencies.
	 *
	 * @since 0.1.0
	 *
	 * @param array $plugins Array containings the plugin dependencies in the TGM format.
	 */
	$plugins = (array) apply_filters( 'wholesales_plugin_dependencies', $plugins );

	$config = array(
		'id'           => 'wholesales',                    // Unique ID for hashing notices for multiple instances of TGMPA.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
