<?php
class wholesales_Style {
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_style' ), 99 );
		add_action( 'enqueue_block_editor_assets', array( $this, 'wholesales_block_editor_styles' ), 20 );
	}
	public function enqueue_style() {
		wp_enqueue_style( 'bootstrap', wholesales_CSS_URL . 'bootstrap-grid.css', false, time() );
		wp_enqueue_style( 'wholesales', get_stylesheet_uri(), null, time() );
		wp_enqueue_style( 'wholesales-style', wholesales_CSS_URL . 'wholesales-style.css', false, time() );
		if (function_exists( 'wholesales_daynamic_styles' )) {
			wp_add_inline_style( 'wholesales-style', wholesales_daynamic_styles() );
		}
	}
	public function wholesales_block_editor_styles() {
		wp_enqueue_style('wholesales-block-styles', wholesales_CSS_URL . 'all-block.css', false, time() );
		wp_enqueue_style( 'wholesales-fonts', wholesales_get_fonts_url(), array(), null );
	}
}
$wholesales_style = new wholesales_Style();
