<?php

/**
 * ReduxFramework Barebones Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */
if (!class_exists('Redux')) {
    return;
}

// This is your option name where all the Redux data is stored.
$wholesales_opt_prefix = 'wholesales_';
$wholesales_opt_name = "wholesales_options";
/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$wholesales_theme = wp_get_theme('wholesales'); // For use with some settings. Not necessary.

$wholesales_args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $wholesales_opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $wholesales_theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $wholesales_theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => esc_html__('Wholesales Option', 'wholesales'),
    'page_title' => esc_html__('Wholesales Option', 'wholesales'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar' => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-portfolio',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the wholesales_opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    // OPTIONAL -> Give you extra features
    'page_priority' => 65,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => '',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '_options',
    // Page slug used to denote the panel
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.
    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    'footer_credit'     => esc_html__( 'wholesales - Personal Multipurpose Template. wholesales is made to be used for business, corporate, creative agencies, and personal websites.', 'wholesales' ),                 // Disable the footer credit of Redux. Please leave if you can help it.
    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
    //'compiler'             => true,   
);

Redux::setArgs($wholesales_opt_name, $wholesales_args);
Redux::setSection($wholesales_opt_name, array(
    'title' => esc_html__('Base theme option', 'wholesales'),
    'id' => 'base_theme_option',
    'desc' => esc_html__('Chnage Base theme option here', 'wholesales'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id' => $wholesales_opt_prefix . 'preloader_on_off',
            'type' => 'switch',
            'title' => esc_html__('Preloader on off switch', 'wholesales'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'wholesales'),
            'off' => esc_html__('Disable', 'wholesales'),
        ),
        array(
            'id' => $wholesales_opt_prefix . 'back_to_top_on_off',
            'type' => 'switch',
            'title' => esc_html__('Back To Top on off switch', 'wholesales'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'wholesales'),
            'off' => esc_html__('Disable', 'wholesales'),
        ),
    )
));
Redux::setSection($wholesales_opt_name, array(
    'title' => esc_html__('Header option', 'wholesales'),
    'id' => 'header_option',
    'desc' => esc_html__('Header option here', 'wholesales'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $wholesales_opt_prefix . 'header_style',
            'type'     => 'select',
            'title'    => esc_html__('Header style', 'wholesales'), 
            'options'  => array(
                '1' => esc_html__('Header style one', 'wholesales'),
                '2' => esc_html__('Header style two', 'wholesales'),
            ),
            'default'  => false,
        ),
        array(
            'required' => array( $wholesales_opt_prefix . 'header_style', '=', '2' ),
            'id' => $wholesales_opt_prefix . 'menu_info_button',
            'type' => 'ace_editor',
            'title' => esc_html__('Svg Icon', 'wholesales'),
            'subtitle' => esc_html__( 'Svg Icon Code: ', 'wholesales' ),
        )
    )
));
Redux::setSection($wholesales_opt_name, array(
    'subsection' => true,
    'title' => esc_html__('Header Top Bar option', 'wholesales'),
    'id' => 'header_top_bar',
    'desc' => esc_html__('Chnage Header Top Bar here', 'wholesales'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id' => $wholesales_opt_prefix . 'top_bar_link',
            'type' => 'ace_editor',
            'title' => esc_html__('Top bar info link ', 'wholesales'),
        ),
        array(
            'id' => $wholesales_opt_prefix . 'top_bar_social_icon',
            'type' => 'ace_editor',
            'title' => esc_html__('Social icon', 'wholesales'),
        ),
    )
));
Redux::setSection($wholesales_opt_name, array(
    'title' => esc_html__('Breadcrumb area', 'wholesales'),
    'id' => 'breadcrumb_area',
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $wholesales_opt_prefix . 'blog_breadcrumb_style',
            'type'     => 'select',
            'title'    => esc_html__('Breadcrumb style', 'wholesales'), 
            'options'  => array(
                '1' => esc_html__('Breadcrumb style one', 'wholesales'),
                '2' => esc_html__('Breadcrumb style two', 'wholesales'),
            ),
            'default'  => false,
        ),
        array(
            'id' => $wholesales_opt_prefix . 'blog_breadcrumb_switch',
            'type' => 'switch',
            'title' => esc_html__('Blog breadcrumb on off switch', 'wholesales'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'wholesales'),
            'off' => esc_html__('Disable', 'wholesales'),
        ),
        array(
            'required' => array( $wholesales_opt_prefix . 'blog_breadcrumb_switch', '=', '1' ),
            'id'       => $wholesales_opt_prefix . 'blog_breadcrumb_bg',
            'type'     => 'background', 
            'url'      => true,
            'title'    => esc_html__('Blog breadcrumb background', 'wholesales'),
            'output'    => array(
                'background' => '.blog-breadcrumb', 
            )
        ),
        array(
            'required' => array( $wholesales_opt_prefix . 'blog_breadcrumb_switch', '=', '1' ),
            'id' => $wholesales_opt_prefix . 'blog_breadcrumb_content',
            'type' => 'text',
            'title' => esc_html__('Blog breadcrumb title', 'wholesales'),
            'default' => esc_html__('OUR NEWS', 'wholesales'),
        ),
        array(
            'id' => $wholesales_opt_prefix . 'blog_single_breadcrumb_switch',
            'type' => 'switch',
            'title' => esc_html__('Blog Single breadcrumb on off switch', 'wholesales'),
            'default' => FALSE,
            'on' => esc_html__('Enable', 'wholesales'),
            'off' => esc_html__('Disable', 'wholesales'),
        ),
        array(
            'required' => array( $wholesales_opt_prefix . 'blog_single_breadcrumb_switch', '=', '1' ),
            'id'       => $wholesales_opt_prefix . 'blog_single_breadcrumb_bg',
            'type'     => 'background', 
            'url'      => true,
            'title'    => esc_html__('Blog Single breadcrumb background', 'wholesales'),
            'output'    => array(
                'background' => '.blog-single-breadcrumb', 
            )
        ),
        array(
            'required' => array( $wholesales_opt_prefix . 'blog_single_breadcrumb_switch', '=', '1' ),
            'id' => $wholesales_opt_prefix . 'blog_single_breadcrumb_content',
            'type' => 'text',
            'title' => esc_html__('Blog single breadcrumb title', 'wholesales'),
            'default' => esc_html__('NEWS DETAILS', 'wholesales'),
        ),
    )
));
Redux::setSection($wholesales_opt_name, array(
    'title' => esc_html__('Blog Design option', 'wholesales'),
    'id' => 'wholesales_blog_area',
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $wholesales_opt_prefix . 'blog_post_style',
            'type'     => 'select',
            'title'    => esc_html__('Blog style', 'wholesales'), 
            'options'  => array(
                '1' => esc_html__('Blog style one', 'wholesales'),
                '2' => esc_html__('Blog style two', 'wholesales'),
            ),
            'default'  => false,
        ),
    )
));
Redux::setSection($wholesales_opt_name, array(
    'title' => esc_html__('Footer option', 'wholesales'),
    'id' => 'wholesales_footer_area',
    'desc' => esc_html__('Chnage footer option here', 'wholesales'),
    'icon' => 'el el-home',
    'fields' => array(
        array(
            'id'       => $wholesales_opt_prefix . 'footer_top_elementor_widget',
            'type'     => 'select',
            'multi' => true,
            'title'    => esc_html__('Footer top Elementor widget', 'wholesales'), 
            'options'  => wholesales_elementor_library(),
        ),
        array(
            'id'       => $wholesales_opt_prefix . 'footer_style',
            'type'     => 'select',
            'title'    => esc_html__('Footer style', 'wholesales'), 
            'options'  => array(
                '1' => esc_html__('Footer style one', 'wholesales'),
                '2' => esc_html__('Footer style two', 'wholesales'),
            ),
            'default'  => false,
        ),
        array(
            'id' => $wholesales_opt_prefix . 'footer_copyright',
            'type' => 'text',
            'title' => esc_html__('Copyright text', 'wholesales'),
        ),
    )
));
