<?php
/**
 * Register meta boxes
 *
 * @return void
 */
add_filter('rwmb_meta_boxes', 'wholesales_theme_meta_box');

function wholesales_theme_meta_box($meta_boxes) {
    $prefix = 'wholesales_theme_metabox';
    $posts_page = get_option('page_for_posts');
    if (!isset($_GET['post']) || intval($_GET['post']) != $posts_page) {
        $meta_boxes[] = array(
            'id' => $prefix . '_page_meta_box',
            'title' => esc_html__('Page Design Settings', 'wholesales'),
            'pages' => array(
                'page',
            ),
            'context' => 'normal',
            'priority' => 'core',
            'fields' => array(
                array(
					'id'      => "{$prefix}_show_breadcrumb",
					'name'    => esc_html__( 'show breadcrumb', 'wholesales' ),
					'desc'    => '',
					'type'    => 'radio',
					'std'     => 'on',
					'options' => array(
						'on'  => 'on',
						'off' => 'off',
					),
                ),               
            )
        );
    }
    return $meta_boxes;
}
