<?php
/**
 * wholesales functions and definitions [wholesales]
 * 
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * wholesales
 * @package wholesales  
 */
defined('wholesales_THEME_URI') or define('wholesales_THEME_URI', get_template_directory_uri()); // wholesales
define('wholesales_THEME_DRI', get_template_directory());
define('wholesales_IMG_URL', wholesales_THEME_URI . '/assets/images/');
define('wholesales_CSS_URL', wholesales_THEME_URI . '/assets/css/');
define('wholesales_JS_URL', wholesales_THEME_URI . '/assets/js/');
define('wholesales_FRAMEWORK_DRI', wholesales_THEME_DRI . '/inc/framework/');
require_once wholesales_FRAMEWORK_DRI . 'styles/index.php';
require_once wholesales_FRAMEWORK_DRI . 'styles/daynamic-style.php';
require_once wholesales_FRAMEWORK_DRI . 'scripts/index.php';
require_once wholesales_FRAMEWORK_DRI . 'redux/redux-config.php';
require_once wholesales_FRAMEWORK_DRI . 'meta-box/config-meta-box.php';
require_once wholesales_FRAMEWORK_DRI . "tgm/tgm.php";
require_once wholesales_FRAMEWORK_DRI . "classes/wholesales-int.php";
require_once wholesales_FRAMEWORK_DRI . "classes/wholesales-act.php";
/**
 * Theme option compatibility.
 */
if ( ! function_exists( 'wholesales_get_options' ) ) :
	function wholesales_get_options( $key ) {
		global $wholesales_options;
		$opt_pref = 'wholesales_';
		if ( empty( $wholesales_options ) ) {
			$wholesales_options = get_option( $opt_pref . 'options' );
		}
		$index = $opt_pref . $key;
		if(!isset($wholesales_options[ $index ])) {
			return false;
		}
		return $wholesales_options[ $index ];
	}
endif;
if ( ! function_exists( 'wholesales_setup' ) ) :
	function wholesales_setup() {
		// load theme textdomain
		load_theme_textdomain( 'wholesales', get_template_directory() . '/languages' );

		// Add support for automatic feed links.
		add_theme_support( 'automatic-feed-links' );

		// Add support for title tag
		add_theme_support( 'title-tag' );

		// Add support for post thumbnails.
		add_theme_support( 'post-thumbnails' );

		
		// Add support for register_block_style.
		add_theme_support( 'register_block_style' );
		
		// Add support for register_block_pattern.
		add_theme_support( 'register_block_pattern' );


		// registe av menus.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'wholesales' ),
		) );

		// Add support for post formats.
		add_theme_support('post-formats', array(
            'aside',
            'image',
            'gallery',
            'audio',
            'video',
            'link',
            'quote',
		));
		
		 // Add support for Block Styles.
		 add_theme_support('wp-block-styles');

		 // Add support for full and wide align images.
		 add_theme_support('align-wide');
 
		 // Add support for editor styles.
		 add_theme_support('editor-styles');
		 
 		// Add support for responsive embedded content.
		 add_theme_support('responsive-embeds');

		 // Add custom editor font sizes.
		 add_theme_support(
			'editor-font-sizes', array(
				array(
					'name' => esc_html__('Small', 'wholesales'),
					'shortName' => esc_html__('S', 'wholesales'),
					'size' => 23,
					'slug' => 'small',
				),
				array(
					'name' => esc_html__('Normal', 'wholesales'),
					'shortName' => esc_html__('M', 'wholesales'),
					'size' => 31,
					'slug' => 'normal',
				),
				array(
					'name' => esc_html__('Large', 'wholesales'),
					'shortName' => esc_html__('L', 'wholesales'),
					'size' => 35,
					'slug' => 'large',
				),
				array(
					'name' => esc_html__('Huge', 'wholesales'),
					'shortName' => esc_html__('XL', 'wholesales'),
					'size' => 40,
					'slug' => 'huge',
				),
			)
		);

		// Add custom editor editor color palette.
        add_theme_support('editor-color-palette', array(
            array(
                'name' => esc_html__('strong yellow', 'wholesales'),
                'slug' => 'strong-yellow',
                'color' => '#f7bd00',
            ),
            array(
                'name' => esc_html__('strong white', 'wholesales'),
                'slug' => 'strong-white',
                'color' => '#fff',
            ),
            array(
                'name' => esc_html__('light black', 'wholesales'),
                'slug' => 'light-black',
                'color' => '#242424',
            ),
            array(
                'name' => esc_html__('very light gray', 'wholesales'),
                'slug' => 'very-light-gray',
                'color' => '#797979',
            ),
            array(
                'name' => esc_html__('very dark black', 'wholesales'),
                'slug' => 'very-dark-black',
                'color' => '#000000',
            ),
		));

		// Add editor style
		add_editor_style(wholesales_CSS_URL . 'editor-style.css');
		add_editor_style(array(wholesales_get_fonts_url()));
		
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Indicate that the theme works well in both Standard and Transitional template modes of the AMP plugin.
		add_theme_support(
			'amp',
			array(
				// The `paired` flag means that the theme retains logic to be fully functional when AMP is disabled.
				'paired' => true,
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'wholesales_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'wholesales_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function wholesales_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'wholesales_content_width', 640 );
}
add_action( 'after_setup_theme', 'wholesales_content_width', 0 );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * wholesales TGM compatibility.
 */

wholesales\TGM\setup();

/**
 * wholesales is_blog compatibility.
 */
function wholesales_is_blog() {
    if ((is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_single()) || (is_tag())) {
        return true;
    } else {
        return false;
    }
}

/**
 * wholesales elementor library compatibility.
 */
function wholesales_elementor_library() {
    $pageslist = get_posts(array(
        'post_type' => 'elementor_library',
        'posts_per_page' => -1
		));
	$pagearray = array();
	if(!empty($pageslist)) {
		foreach ($pageslist as $page) {
			$pagearray[$page->ID] = $page->post_title;
		}
	}
    return $pagearray;
}


/**
* Enqueue theme fonts.
*/
function wholesales_fonts() {
	$fonts_url = wholesales_get_fonts_url();

	// Load Fonts if necessary.
	if ( $fonts_url ) {
		require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );
		wp_enqueue_style( 'wholesales-fonts', wptt_get_webfont_url( $fonts_url ), array(), null );
	}
}
add_action( 'wp_enqueue_scripts', 'wholesales_fonts', 1 );
add_action( 'enqueue_block_editor_assets', 'wholesales_fonts', 1 );


/**
 * Retrieve webfont URL to load fonts locally.
 */
function wholesales_get_fonts_url() {
	$font_families = array(
		'Poppins:300,400,500,600,700,800,900',
	);

	$query_args = array(
		'family'  => urlencode( implode( '|', $font_families ) ),
		'subset'  => urlencode( 'latin,latin-ext' ),
		'display' => urlencode( 'swap' ),
	);

	return apply_filters( 'wholesales_get_fonts_url', add_query_arg( $query_args, 'https://fonts.googleapis.com/css' ) );
}

/**
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
 */
if ( ! function_exists( 'wp_body_open' ) ) :
	function wp_body_open() {
		// Triggered after the opening <body> tag.
		do_action( 'wp_body_open' );
	}
endif;	
