<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package wholesales
 */
	$footer_style   = wholesales_get_options( 'footer_style' );
	$footer_copyright   = wholesales_get_options( 'footer_copyright' );
	$footer_style_class = '';
	if( $footer_style == '2' ) :
		$footer_style_class = 'footer-style-two';
	endif;
?>
	<?php
		$footer_top_elementor_widget = wholesales_get_options('footer_top_elementor_widget');
		if (class_exists("\\Elementor\\Plugin")) {
			if( is_array($footer_top_elementor_widget) && !empty($footer_top_elementor_widget) ) :
				$pluginElementor = \Elementor\Plugin::instance();
				foreach($footer_top_elementor_widget as $single_value){
					$wholesales_all_save_element = $pluginElementor->frontend->get_builder_content($single_value);
					echo do_shortcode($wholesales_all_save_element) ;
				}
			endif;
		}
	?>
	 

    <footer class="footer-area <?php echo esc_attr( $footer_style_class ); ?>">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="footer-content">
						<div class="footer-copyright">
							<p>
								<?php
									if ( $footer_copyright != '' ) :
										echo wp_kses( $footer_copyright, 'code_contxt' );
								?>
									<a href="<?php echo esc_url( __( 'https://gutenplayer.com/', 'wholesales' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Design by Gutenplayer', 'wholesales' ); ?>
									</a>
								<?php
									else :
								?>
									&copy;
									<?php
									echo esc_html(
										date_i18n(
										/* translators: Copyright date format, see https://www.php.net/date */
											_x( 'Y', 'copyright date format', 'wholesales' )
										)
									);
									?>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>,
									<?php
										printf(
											'%s <a href="%s" target="_blank">%s</a> %s',
											esc_html__( 'Designed by', 'wholesales' ),
											esc_url( 'gutenplayer.com' ),
											esc_html( 'Gutenplayer' ),
											esc_html__( 'and proudly', 'wholesales' )
										);
									?>
									<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'wholesales' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Powered by WordPress', 'wholesales' ); ?>
									</a>
								<?php endif; ?>
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>	
	
	<?php 
		do_action('wholesales_back_to_top_ready');
	?>
<?php wp_footer(); ?>
</body>
</html>
