<?php
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */


if ( ! function_exists( 'whimsy_body_classes' ) ) :
    add_filter( 'body_class', 'whimsy_body_classes' );

    function whimsy_body_classes( $classes ) {

        // Adds a class of group-blog to blogs with more than 1 published author.
        if ( is_multi_author() ) {
            $classes[] = 'group-blog';
        }

        return $classes;

    }
endif;